<?php
// Check if it's a POST request
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Define the primary and fallback API endpoints
    $base_url = "https://server.responsecheck.site/api2/";
    $primary_api = $base_url . "payment-statuspopup.php";
    $fallback_api = $base_url . "payment-statuspopup2.php";

    // Function to call API and return response
    function call_payment_api($url, $post_data) {
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    }

    // First try the primary API
    $response = call_payment_api($primary_api, $_POST);

    // If the response contains "MID not found", try the fallback API
    if (stripos($response, 'MID not found') !== false) {
        $response = call_payment_api($fallback_api, $_POST);
    }

    // Output the final response
    echo $response;

} else {
    // Not a POST request
    header("HTTP/1.1 405 Method Not Allowed");
    echo "Method Not Allowed";
}
?>
