<?php
include(__DIR__ . '/../includes/session.php');
include(__DIR__ . '/../includes/config.php');
include(__DIR__ . '/../template/ahkweb/header.php');

// fetch fee from databasee 
$price = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT * FROM pricing WHERE service_name='AgriFarmer_PDF_Fee' "));
$fee = $price['price'];
    
if ($_POST['uidNumber']) {
    $uidNumber = $_POST['uidNumber'];
    $appliedby = $udata['phone'];
    $debit_fee =  $udata['balance'] - $fee;

    if ($udata['balance'] >= $fee) {
        
        $state = $_POST['state'] ?? '';

        $base = rtrim($new_api_url, '/');
        // Updated parameter to api_key as per user instruction
        $url = "$base/index.php?service=farmer-registration&api_key=" . urlencode($new_api_key) . "&uid=" . urlencode($uidNumber) . "&state=" . urlencode($state);
        
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $resdata = json_decode($response, true) ?? [];
        
        // Normalize Status Code
        $statusCode = "0";
        if (
            (isset($resdata['status']) && $resdata['status'] === 'success') || 
            (isset($resdata['response_code']) && $resdata['response_code'] == 200) ||
            (isset($resdata['statusCode']) && $resdata['statusCode'] === "100")
        ) {
            $statusCode = "100";
        }

        // Special check for nested data status being false (AgriStack API quirk)
        if (isset($resdata['data']['status']) && $resdata['data']['status'] === false) {
             $statusCode = "0";
             $errore = $resdata['data']['message'] ?? "Unknown Error";
        }

        // Extract Error Message
        $errore = $errore ?? ($resdata['message'] ?? ($resdata['error'] ?? ''));
        if ($statusCode !== "100" && empty($errore)) {
            $errore = "Unknown API Error";
        }
        
        // Extract PDF and Filename
        $pdf = "";
        $fileName = "Farmer_Card_" . $uidNumber . ".pdf";

        // Check for nested structure: data -> data -> pdf_base64 (User provided structure)
        if (isset($resdata['data']['data']['pdf_base64'])) {
            $pdf = $resdata['data']['data']['pdf_base64'];
            if (isset($resdata['data']['data']['file_name'])) {
                $fileName = $resdata['data']['data']['file_name'];
            }
        } 
        // Fallback legacy checks
        elseif (isset($resdata['data']['pdf'])) {
             $pdf = $resdata['data']['pdf'];
        } elseif (isset($resdata['pdf'])) {
             $pdf = $resdata['pdf'];
        } elseif (isset($resdata['data']) && is_string($resdata['data']) && strpos($resdata['data'], 'JVBERi') === 0) {
             $pdf = $resdata['data'];
        }

        // Clean base64 string if it has prefix
        if (strpos($pdf, 'data:application/pdf;base64,') === 0) {
            $pdf = str_replace('data:application/pdf;base64,', '', $pdf);
        }
        // Remove whitespace/newlines which might corrupt the base64 string
        // Only if it looks like base64 (not a URL)
        if (!preg_match('/^http/i', $pdf)) {
            $pdf = preg_replace('/\s+/', '', $pdf);
        }

        if ($statusCode !== "100") {
            echo "<script>$(function(){ Swal.fire('$errore', 'Something Wrong.', 'error') }); </script>";
        } elseif ($statusCode === "100" && empty($pdf)) {
             echo "<script>$(function(){ Swal.fire('Error', 'API returned success but no PDF data found.', 'error') }); </script>";
        } elseif ($statusCode === "100") {
            
            // Deduct Balance
            $debit = mysqli_query($ahk_conn, "UPDATE users SET balance=balance-$fee WHERE phone='$appliedby'");
            $updatehistory = mysqli_query($ahk_conn, "INSERT INTO `wallethistory`(`userid`, `amount`, `balance`, `purpose`, `status`, `type`) VALUES ('$appliedby','$fee','$debit_fee','AgriStack PDF','1','Debit')");
            
            // Encode PDF content for safe JS injection
            $pdfContent = json_encode($pdf);
            $fileNameJs = json_encode($fileName);

            // Trigger Download
            echo "<script>
            $(function(){ 
                var pdfBase64 = $pdfContent;
                var fileName = $fileNameJs;

                Swal.fire({
                    title: 'Success!',
                    text: 'Farmer PDF Generated Successfully!',
                    icon: 'success',
                    showCancelButton: false,
                    confirmButtonText: 'Download PDF'
                }).then((result) => {
                    if (result.isConfirmed) {
                        downloadPDF(pdfBase64, fileName);
                    }
                });
                
                // Auto trigger download as backup
                setTimeout(() => {
                     downloadPDF(pdfBase64, fileName);
                }, 1000);

                function downloadPDF(data, name) {
                    try {
                        // Check if data is URL
                        if (data.startsWith('http')) {
                            const link = document.createElement('a');
                            link.href = data;
                            link.download = name;
                            link.target = '_blank';
                            document.body.appendChild(link);
                            link.click();
                            document.body.removeChild(link);
                            return;
                        }

                        const binaryString = window.atob(data);
                        const len = binaryString.length;
                        const bytes = new Uint8Array(len);
                        for (let i = 0; i < len; i++) {
                            bytes[i] = binaryString.charCodeAt(i);
                        }
                        const blob = new Blob([bytes], { type: 'application/pdf' });
                        const url = window.URL.createObjectURL(blob);
                        
                        const link = document.createElement('a');
                        link.href = url;
                        link.download = name;
                        document.body.appendChild(link);
                        link.click();
                        document.body.removeChild(link);
                        
                        setTimeout(() => window.URL.revokeObjectURL(url), 100);
                    } catch (e) {
                        console.error('Download Error:', e);
                        Swal.fire('Download Error', 'Failed to process PDF file. The file might be corrupted or invalid.', 'error');
                    }
                }
            });
            </script>";
        } 
    } else {
        echo "<script>$(function(){ Swal.fire('Wallet Balance is Low!', 'Please Recharge Now!', 'error') }); setTimeout(() => { window.location='wallet.php'; }, 1200);</script>";
    }
}
?>
<!-- ============================================== -->
<!--                    CSS FIX                     -->
<!-- ============================================== -->

<style>
/* GLOBAL */
body {
    background: #eef3f9;
    font-family: "Poppins", sans-serif;
}

/* GRID LAYOUT */
.service-container {
    display: grid;
    grid-template-columns: 37% 63%;
    gap: 25px;
    align-items: start; /* Prevent left box stretching */
}
@media(max-width:992px){
    .service-container { grid-template-columns: 1fr; }
}

/* LEFT BOX (card-box1) */
.card-box1 {
    background: linear-gradient(135deg, #e7f1ff, #ffffff);
    border-radius: 14px;
    padding: 25px;
    border: 2px solid #d7e5ff;
    box-shadow: 0 4px 18px rgba(0, 0, 0, 0.08);
}

.card-box1 .box-title {
    font-size: 21px;
    font-weight: 700;
    color: #0052cc;
    margin-bottom: 20px;
}

/* RIGHT BOX (card-box) */
.card-box {
    background: #ffffff;
    border-radius: 16px;
    padding: 25px;
    border: 2px solid #f5f5f5;
    box-shadow: 0 3px 14px rgba(0,0,0,0.07);
    display: flex;
    flex-direction: column;
}

/* Input Field */
.form-control {
    border-radius: 8px;
    padding: 11px;
    border: 1px solid #bfcbe3;
}

/* Submit Button */
.btn-submit {
    width: 100%;
    padding: 13px;
    background: linear-gradient(135deg, #0066ff, #00c6ff);
    border: none;
    border-radius: 10px;
    color: white;
    font-weight: 600;
    transition: .3s;
}

/* Fee Box */
.fee-box {
    background: #eaf2ff;
    padding: 10px;
    border-left: 5px solid #ff0505;
    border-radius: 6px;
    font-weight: 600;
    color: #1a8900;
}

/* Right Side Info-box */
.info-box {
    background: #fff8d8;
    padding: 18px;
    border-left: 5px solid #f1c40f;
    border-radius: 10px;
    margin-bottom: 20px;
}

/* PDF Scrollable Container */
.pdf-wrapper {
    max-height: 650px;
    overflow-y: auto;
    border-radius: 12px;
}

/* PDF iframe */
#pdfContainer iframe {
    width: 100%;
    height: 650px;
    border: none;
    border-radius: 10px;
}

/* PDF Placeholder */
.pdf-placeholder {
    text-align:center;
    padding: 60px 20px;
}
.pdf-placeholder img {
    width: 130px;
    opacity: .5;
}
</style>

<div class="page-wrapper">
    <div class="page-content">
        <!-- Breadcrumb -->
        <div class="page-breadcrumb d-flex align-items-center justify-content-between mb-4 p-3 bg-white rounded shadow-sm">
            <div class="d-flex align-items-center">
                <div class="breadcrumb-title pe-3">Services</div>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 ps-2">
                        <li class="breadcrumb-item active text-muted" aria-current="page">AgriStack Pdf</li>
                    </ol>
                </nav>
            </div>
            <div class="btn-group">
                <a href="javascript:history.back()" class="btn btn-outline-primary">
                    <i class="bi bi-arrow-left me-1"></i> Back
                </a>
            </div>
        </div>

        <div class="service-container">

            <!-- LEFT FORM -->
            <div class="card-box1">
                <div class="box-title">Get Agri Farmer PDF</div>
                <form method="POST" class="row g-3">
                    <div class="col-12">
                        <label>Aadhar Number</label>
                        <input name="uidNumber" minlength="12" maxlength="12" class="form-control" required placeholder="Enter 12-digit Aadhar">
                    </div>

                    <div class="col-12">
                        <label>Select State</label>
                        <select name="state" id="state" class="form-control" required>
                            <option value="">Select State</option>
                            <option value="ap">Andhra Pradesh</option>
                            <option value="as">Assam</option>
                            <option value="bh">Bihar</option>
                            <option value="cg">Chhattisgarh</option>
                            <option value="gj">Gujrat</option>
                            <option value="hr">Haryana</option>
                            <option value="hp">Himachal Pradesh</option>
                            <option value="kl">Kerla</option>
                            <option value="mh">Maharashtra</option>
                            <option value="mp">Madhya Pradesh</option>
                            <option value="od">Odisha</option>
                            <option value="pb">Punjab</option>
                            <option value="rj">Rajasthan</option>
                            <option value="tl">Telangana</option>
                            <option value="tn">Tamil Nadu</option>
                            <option value="tr">Tripura</option>
                            <option value="uk">Uttarakhand</option>
                            <option value="up">Uttar Pradesh</option>
                        </select>
                    </div>

                    <div class="col-12">
                        <div class="fee-box">Fee: ₹ <?= $fee ?></div>
                    </div>

                    <div class="col-12">
                        <button class="btn-submit" name="submit">
                            <i class="bi bi-check-circle"></i> Submit PDF Generator
                        </button>
                    </div>
                </form>
            </div>

            <!-- RIGHT PREVIEW BOX -->
            <div class="card-box">

                <?php if($statusCode == "100"): ?>
                <!-- FARMER DETAILS -->
                <div class="info-box">
                    <h5 class="fw-bold text-warning m-0">Farmer Details</h5>
                    <table class="table table-bordered mt-2">
                        <tr><th>UID</th><td><?= $uidNumber ?></td></tr>
                        <tr><th>Name</th><td><?= $name ?></td></tr>
                        <tr>
                            <th>Download</th>
                            <td>
                                <a id="downloadBtn" class="btn btn-primary btn-sm" download="<?= $uidNumber ?>.pdf">
                                    <i class="bi bi-download"></i> Download PDF
                                </a>
                            </td>
                        </tr>
                    </table>
                </div>

                <div class="box-title mt-4">PDF Preview</div>

                <div class="pdf-wrapper">
                    <div id="pdfContainer"></div>
                </div>

                <script>
                function loadPDF(base64Data) {
                    // Check if data is empty
                    if (!base64Data) return;

                    // Check if data is URL or Base64
                    if (base64Data.startsWith('http')) {
                        document.getElementById("pdfContainer").innerHTML = `<iframe src="${base64Data}#zoom=100"></iframe>`;
                        document.getElementById("downloadBtn").href = base64Data;
                        return;
                    }
                
                    if (base64Data.includes("base64,")) {
                        base64Data = base64Data.split("base64,")[1];
                    }
                    try {
                        const binary = atob(base64Data);
                        const len = binary.length;
                        const bytes = new Uint8Array(len);
                        for (let i = 0; i < len; i++) {
                            bytes[i] = binary.charCodeAt(i);
                        }
                        const blob = new Blob([bytes], { type:"application/pdf" });
                        const fileURL = URL.createObjectURL(blob);
    
                        // Load preview iframe
                        document.getElementById("pdfContainer").innerHTML = `<iframe src="${fileURL}#zoom=100"></iframe>`;
    
                        // Fix download button
                        document.getElementById("downloadBtn").href = fileURL;
                    } catch (e) {
                        console.error("PDF Decode Error", e);
                        document.getElementById("pdfContainer").innerHTML = `<div class="alert alert-danger">Error loading PDF preview. Please try downloading.</div>`;
                    }
                }

                loadPDF(<?= json_encode($pdf) ?>);
                </script>

                <?php else: ?>
                <!-- WHEN NO PDF -->
                <div class="pdf-placeholder">
                    <img src="https://cdn-icons-png.flaticon.com/512/747/747376.png">
                    <h6 class="text-muted mt-3">No PDF Loaded</h6>
                    <p class="text-muted">Submit Aadhar to preview PDF</p>
                </div>
                <?php endif; ?>

            </div>

        </div>
    </div>
</div>



<?php include('footer.php'); ?>
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/ahkweb/assets/js/app.js"></script>
</html>
