<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

// fetch fee from database
$price = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT * FROM pricing WHERE service_name='npci_status_check' "));
$fee = $price['price'];

$resdata = [];
if (isset($_POST['uidNumber'])) {
    $uidNumber = trim($_POST['uidNumber']);
    $appliedby = $udata['phone'];
    $debit_fee = $udata['balance'] - $fee;

    if ($udata['balance'] >= $fee) {
        
        if (empty($new_api_key) || empty($new_api_url)) {
             echo "<script>$(function(){ Swal.fire('System Error', 'New API Configuration Missing', 'error') });</script>";
             exit;
        }

        $base = rtrim($new_api_url, '/');
        $url = $base . '/index.php?' . http_build_query([
            'api_key'        => $new_api_key,
            'service'        => 'dbt-aadhaar',
            'aadhaar_number' => $uidNumber
        ]);

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 60,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_SSL_VERIFYPEER => false
        ]);

        $response = curl_exec($curl);
        curl_close($curl);

        $json = json_decode($response, true) ?? [];
        $resdata = [];
        $error_message = '';

        if (isset($json['status']) && $json['status'] === 'success' && isset($json['data']) && is_array($json['data'])) {
            $data = $json['data'];
            if (!empty($data['success']) && (isset($data['statuscode']) && (int)$data['statuscode'] === 200) && isset($data['dbt_data']) && is_array($data['dbt_data'])) {
                $dbt = $data['dbt_data'];
                $uidFromApi = $data['uid'] ?? $uidNumber;
                $statusText = !empty($dbt['status']) ? 'DBT Active / Found' : 'DBT Not Active / Not Found';
                $lastUpdated = $data['verified_at'] ?? ($data['full_response']['created_at'] ?? 'N/A');
                $resdata = [
                    'code'          => '100',
                    'message'       => $dbt['message'] ?? ($data['message'] ?? 'DBT status fetched'),
                    'uidNumber'     => $uidFromApi,
                    'statusMessage' => $statusText,
                    'bankName'      => $dbt['bank'] ?? 'N/A',
                    'lastupdatedate'=> $lastUpdated
                ];
            } else {
                $error_message = $data['error'] ?? ($data['verify_data']['message'] ?? 'DBT verification failed');
            }
        } else {
            $error_message = $json['message'] ?? 'Unexpected API response';
        }

        if (isset($resdata['code']) && $resdata['code'] === "100") {
            mysqli_query($ahk_conn, "UPDATE users SET balance=balance-$fee WHERE phone='$appliedby'");
            mysqli_query($ahk_conn, "INSERT INTO `wallethistory`(`userid`, `amount`, `balance`, `purpose`, `status`, `type`) 
                VALUES ('$appliedby','$fee','$debit_fee','Npci Status Check','1','Debit')");
        } else {
            if ($error_message === '') {
                $error_message = 'Something went wrong.';
            }
            echo "<script>$(function(){ Swal.fire('Error', '".htmlspecialchars($error_message, ENT_QUOTES, 'UTF-8')."', 'error') }); setTimeout(() => { window.location=''; }, 5000);</script>";
        }
    } else {
        echo "<script>$(function(){ Swal.fire('Wallet Balance is Low!', 'Please Recharge Now!', 'error') }); setTimeout(() => { window.location='wallet.php'; }, 1200);</script>";
    }
}
?>

<!-- Page Wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <!-- Breadcrumb with Action Buttons -->
        <div class="page-breadcrumb d-flex align-items-center justify-content-between mb-4 p-3 bg-white rounded shadow-sm">
            <div class="d-flex align-items-center">
                <div class="breadcrumb-title pe-3">Services</div>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 ps-2">
                        <li class="breadcrumb-item active text-muted" aria-current="page">Bharat Aadhaar Seeding</li>
                    </ol>
                </nav>
            </div>
            <div class="btn-group">
                
                <a href="javascript:history.back()" class="btn btn-outline-primary">
                    <i class="bi bi-arrow-left me-1"></i> Back
                </a>
            </div>
        </div>

      

        <!-- Head Content -->

        <head>
            <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
            <style>
                .hidden {
                    display: none;
                }
            </style>
        </head>

        <body>
            <div class="container-fluid pt-4 px-4">
                <div class="row">

                    <!-- Form Section -->
                    <div class="col-lg-5 mb-4">
                        <div class="card">
                            <div class="card-body">
                                <h3 class="card-title text-dark text-center"><strong>Npci Status Check</strong></h3>
                                <form action="" method="POST" class="row g-3">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label for="uidNumber">Enter Aadhaar Number</label>
                                            <input name="uidNumber" type="text" id="uidNumber"
                                                placeholder="Enter Aadhaar Number" class="form-control" required
                                                maxlength="12" pattern="\d{12}"
                                                oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0,12); this.setCustomValidity('');"
                                                oninvalid="this.setCustomValidity('Please enter 12 digit Aadhaar number')">

                                            <input type="hidden" name="check" value="aadhaar">
                                        </div>
                                        <hr>
                                        <div class="row mt-3">
                                            <div class="col-md-6">
                                                <input class="form-control"
                                                    value="Fee ₹ <?php echo htmlspecialchars($fee); ?>" readonly>
                                            </div>
                                            <div class="col-md-6 text-end">
                                                <button class="btn btn-success" name="submit" id="submit">
                                                    <i class="fa fa-check-circle"></i> Submit
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <!-- Result Section -->
                    <?php if (isset($resdata['code']) && $resdata['code'] === "100") { ?>
                        <div class="col-lg-7 col-md-6 col-sm-6">
                            <div class="card" style="background-color: #FCF3CF;" id="printSection">
                                <div class="card-body">
                                    <h5 class="mb-3">Npci Status Check Result</h5>
                                    <table class="table table-bordered table-striped">
                                        <tbody>
                                            <tr>
                                                <th>Message</th>
                                                <td><?php echo htmlspecialchars($resdata['message'] ?? ''); ?></td>
                                            </tr>
                                            <tr>
                                                <th>Aadhaar Number</th>
                                                <td><?php echo htmlspecialchars($resdata['uidNumber'] ?? $uidNumber); ?>
                                                </td>
                                            </tr>
                                            <tr>
                                                <th>Status</th>
                                                <td><?php echo htmlspecialchars($resdata['statusMessage'] ?? ''); ?></td>
                                            </tr>
                                            <tr>
                                                <th>Bank Name</th>
                                                <td><?php echo htmlspecialchars($resdata['bankName'] ?? 'N/A'); ?></td>
                                            </tr>
                                            <tr>
                                                <th>Last Updated</th>
                                                <td><?php echo htmlspecialchars($resdata['lastupdatedate'] ?? 'N/A'); ?>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>

                                    <div class="text-end mt-3">
                                        <button class="btn btn-primary" onclick="printVerification()">🖨️ Print</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>

                </div>
                <br><br><br><br>
            </div>

            <script>
                function printVerification() {
                    var content = document.getElementById("printSection").innerHTML;
                    var printWindow = window.open('', '_blank', 'width=800,height=600');
                    printWindow.document.write(`
                        <html>
                            <head>
                                <title>Npci Status Check</title>
                                <style>
                                    body { font-family: Arial, sans-serif; padding: 20px; }
                                    table { width: 100%; border-collapse: collapse; }
                                    th, td { border: 1px solid #000; padding: 8px; text-align: left; }
                                    th { background-color: #f2f2f2; }
                                    h5 { margin-bottom: 20px; }
                                </style>
                            </head>
                            <body>
                                ${content}
                                <script>
                                    window.onload = function() { window.print(); };
                                <\/script>
                            </body>
                        </html>
                    `);
                    printWindow.document.close();
                }
            </script>
        </body>
    </div>
</div>


<?php include('footer.php'); ?>

<!-- Required JS -->
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/ahkweb/assets/js/app.js"></script>
