<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');
date_default_timezone_set('Asia/Kolkata');

$resdata = [];
$instantResult = null;

if (isset($_POST['check']) && $_POST['check'] === "pan") {
    $panNumber = strtoupper(trim(mysqli_real_escape_string($ahk_conn, $_POST['panNumber'])));
    $application_no = "INSTANT" . rand(100000, 999999);
    $username = $udata['phone'];
    $appliedby = $udata['phone'];
    $mobile = $udata['phone'];
    $clint_id = $clint;

    // Get service price
    $price_query = mysqli_query($ahk_conn, "SELECT price FROM pricing WHERE service_name='Pan_To_Aadhaar_find'");
    $price_row = mysqli_fetch_assoc($price_query);
    $fee = floatval($price_row['price']);
    $wallet_amount = floatval($udata['balance']);
    $debit_fee = $wallet_amount - $fee;

    if ($wallet_amount >= $fee) {
        if (empty($new_api_key) || empty($new_api_url)) {
            echo "<script>$(function(){ Swal.fire('System Error', 'New API Configuration Missing', 'error') });</script>";
            exit;
        }

        $base = rtrim($new_api_url, '/');
        $url = $base . '/index.php?' . http_build_query([
            'api_key'   => $new_api_key,
            'service'   => 'pan-to-aadhaar',
            'panNumber' => $panNumber
        ]);

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_SSL_VERIFYPEER => false
        ]);
        $response = curl_exec($curl);
        curl_close($curl);

        $resdata = json_decode($response, true);

        if (
            isset($resdata['status']) &&
            $resdata['status'] === 'success' &&
            isset($resdata['data']) &&
            is_array($resdata['data'])
        ) {
            $outer = $resdata['data'];
            $inner = (isset($outer['data']) && is_array($outer['data'])) ? $outer['data'] : [];

            $statusMessage = $outer['message'] ?? ($resdata['message'] ?? 'Success');
            $panFromApi = $inner['panNumber'] ?? ($outer['panNumber'] ?? $panNumber);
            $aadhaarNo = $inner['aadhaarNo'] ?? '';
            $nameFromApi = $inner['name'] ?? '';
            $dobFromApi = $inner['dob'] ?? '';

            $resdata = [
                'status'        => '100',
                'statusMessage' => $statusMessage,
                'panNumber'     => $panFromApi,
                'aadhaarNo'     => $aadhaarNo,
                'name'          => $nameFromApi,
                'dob'           => $dobFromApi
            ];
        }

        if (isset($resdata['status']) && $resdata['status'] == "100") {
            $statusMessage = mysqli_real_escape_string($ahk_conn, $resdata['statusMessage']);
            $message_code = $resdata['status'];
            $requestId = isset($resdata['requestId']) ? mysqli_real_escape_string($ahk_conn, $resdata['requestId']) : '';
            $apiPan = isset($resdata['panNumber']) ? mysqli_real_escape_string($ahk_conn, $resdata['panNumber']) : $panNumber;
            $apiAadhaar = isset($resdata['aadhaarNo']) ? mysqli_real_escape_string($ahk_conn, $resdata['aadhaarNo']) : '';
            $apiName = isset($resdata['name']) ? mysqli_real_escape_string($ahk_conn, $resdata['name']) : '';
            $apiDob = isset($resdata['dob']) ? mysqli_real_escape_string($ahk_conn, $resdata['dob']) : '';

            // Deduct Wallet Balance
            $debit = mysqli_query($ahk_conn, "UPDATE users SET balance = balance - $fee WHERE phone = '$appliedby'");

            // Add to Wallet History
            mysqli_query($ahk_conn, "INSERT INTO wallethistory (userid, amount, balance, purpose, status, type)
                VALUES ('$appliedby', '$fee', '$debit_fee', 'Aadhaar Request (PAN)', '1', 'Debit')");

            if ($debit) {
                $query = "INSERT INTO pan_to_uid_find (
                    application_no, panNumber, name, dob, gender, uid, mobile, username, clint_id,
                    status, status_code, fee, old_balance, new_balance, message
                ) VALUES (?, ?, ?, ?, NULL, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

                $stmt = mysqli_prepare($ahk_conn, $query);

                if ($stmt) {
                    $status = 'Success';
                    mysqli_stmt_bind_param(
                        $stmt,
                        "ssssssssssddds",
                        $application_no,
                        $apiPan,
                        $apiName,
                        $apiDob,
                        $apiAadhaar,
                        $mobile,
                        $username,
                        $clint_id,
                        $status,
                        $message_code,
                        $fee,
                        $wallet_amount,
                        $debit_fee,
                        $statusMessage
                    );

                    $success = mysqli_stmt_execute($stmt);
                    mysqli_stmt_close($stmt);

                    if ($success) {
                        $instantResult = [
                            'pan'           => $apiPan,
                            'aadhaar'       => $apiAadhaar,
                            'name'          => $apiName,
                            'dob'           => $apiDob,
                            'statusMessage' => $statusMessage
                        ];

                        echo "<script>
                            $(function() {
                                Swal.fire(
                                    'Success',
                                    'Aadhaar: " . $apiAadhaar . "',
                                    'success'
                                );
                            });
                        </script>";
                    } else {
                        $error = mysqli_error($ahk_conn);
                        echo "<script>$(function(){ Swal.fire('Insert Failed', 'DB Error: $error', 'error') });</script>";
                    }
                } else {
                    $error = mysqli_error($ahk_conn);
                    echo "<script>$(function(){ Swal.fire('Statement Error', '$error', 'error') });</script>";
                }
            } else {
                echo "<script>$(function(){ Swal.fire('Balance Error', 'Balance debited but insert failed.', 'warning') });</script>";
            }
        } else {
            $message = isset($resdata['message']) ? $resdata['message'] : (isset($resdata['error']) ? $resdata['error'] : "Unknown API Error");
            echo "<script>$(function(){ Swal.fire('API Error', '" . htmlspecialchars($message, ENT_QUOTES, 'UTF-8') . "', 'error') });</script>";
        }
    } else {
        echo "<script>$(function(){ Swal.fire('Insufficient Wallet Balance', 'Please Recharge', 'error') }); setTimeout(() => { window.location='wallet'; }, 1500);</script>";
    }
}
?>




<!-- HTML UI -->
<div class="page-wrapper">
    <div class="page-content">
        <!-- Breadcrumb with Action Buttons -->
        <div class="page-breadcrumb d-flex align-items-center justify-content-between mb-4 p-3 bg-white rounded shadow-sm">
            <div class="d-flex align-items-center">
                <div class="breadcrumb-title pe-3">Services</div>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 ps-2">
                        <li class="breadcrumb-item active text-muted" aria-current="page">Pan To Aadhaar Find Service</li>
                    </ol>
                </nav>
            </div>
            <div class="btn-group">
                <a href="pan-2-aadhaar-list" class="btn btn-success">
                    <i class="bi bi-list-ul me-1"></i> Pan To Aadhaar List
                </a>
                <a href="javascript:history.back()" class="btn btn-outline-primary">
                    <i class="bi bi-arrow-left me-1"></i> Back
                </a>
            </div>
        </div>
        <div class="container-fluid pt-4 px-4">
            <div class="row">
                <div class="col-lg-5 mb-4">
                    <div class="card">
                        <div class="card-body">
                            <h3 class="card-title text-center text-dark"><strong>PAN No To Get Aadhaar No Instant</strong></h3>
                            <form method="POST">
                                <div class="form-group mb-3">
                                    <label for="panNumber">PAN Number <span class="text-danger">*</span></label>
                                    <input name="panNumber" type="text" id="panNumber" placeholder="Enter PAN Number" class="form-control" required>
                                    <input type="hidden" name="check" value="pan">
                                </div>
                                <div class="text-center">
                                    <button type="submit" class="btn btn-primary px-5">Verify Now</button>
                                </div>
                            </form>
                            <div class="text-center mt-3">
                                <div class="fee-container">
                                    <h5 class="text-warning">Application Fee:
                                        <?php  
                                        $price = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT price FROM pricing WHERE service_name='Pan_To_Aadhaar_find'")); 
                                        echo "₹" . $price['price'];
                                        ?>
                                    </h5>
                                </div>
                            </div>

                            <?php if (!empty($instantResult)) : ?>
                                <div class="mt-4 alert alert-success text-start">
                                    <h5 class="mb-3">Instant Aadhaar Result</h5>
                                    <p><strong>PAN:</strong> <?php echo htmlspecialchars($instantResult['pan']); ?></p>
                                    <p><strong>Aadhaar:</strong> <?php echo htmlspecialchars($instantResult['aadhaar']); ?></p>
                                    <?php if (!empty($instantResult['name'])) : ?>
                                        <p><strong>Name:</strong> <?php echo htmlspecialchars($instantResult['name']); ?></p>
                                    <?php endif; ?>
                                    <?php if (!empty($instantResult['dob'])) : ?>
                                        <p><strong>DOB:</strong> <?php echo htmlspecialchars($instantResult['dob']); ?></p>
                                    <?php endif; ?>
                                    <p><strong>Status Message:</strong> <?php echo htmlspecialchars($instantResult['statusMessage']); ?></p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>




		
		<!--end page wrapper -->
		<?php 
		include('footer.php');
		?>
	<!-- Bootstrap JS -->
	

	<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
	<!--plugins-->
	<!-- <script src="../template/ahkweb/assets/js/jquery.min.js"></script> -->
	<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
	<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
	<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
	<!--app JS-->
	<script src="../template/ahkweb/assets/js/app.js"></script>
</body>

<script>
	$(document).ready(function() {
	
	$('#eid').inputmask();
	$('#date').inputmask();
	$('#timea').inputmask("hh:mm:ss", {
        placeholder: "00:00:00", 
        insertMode: false, 
        showMaskOnHover: false,
        hourFormat: 12
      });
	});
</script>
</html>
