<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Function to validate PAN number
function validatePAN($pan) {
    // PAN format: ABCDE1234F (5 letters, 4 digits, 1 letter)
    $pan = strtoupper(trim($pan));
    if (preg_match('/^[A-Z]{5}[0-9]{4}[A-Z]{1}$/', $pan)) {
        return $pan;
    }
    return false;
}

// Read and validate PAN from GET
if (empty($_GET['pan_number'])) {
    http_response_code(400);
    echo json_encode([
        "status" => "error",
        "message" => "Missing required parameter: pan_number"
    ], JSON_UNESCAPED_SLASHES);
    exit;
}

$pan = trim($_GET['pan_number']);
$validatedPAN = validatePAN($pan);

if ($validatedPAN === false) {
    http_response_code(400);
    echo json_encode([
        "status" => "error",
        "message" => "Invalid PAN format. PAN should be in format: ABCDE1234F"
    ], JSON_UNESCAPED_SLASHES);
    exit;
}

$pan = $validatedPAN;

// Real names ki lists
$firstNames = [
    'Rahul', 'Jigar', 'Mohit', 'Amit', 'Suresh', 'Ramesh', 'Vijay', 'Karan', 'Arjun', 'Sandeep',
    'Vikas', 'Deepak', 'Manoj', 'Ajay', 'Ashok', 'Bharat', 'Chetan', 'Dinesh', 'Girish', 'Harish',
    'Imran', 'Kamal', 'Kapil', 'Lalit', 'Manish', 'Mayur', 'Naresh', 'Nitin', 'Pankaj', 'Prakash',
    'Pratik', 'Pravin', 'Raj', 'Rakesh', 'Rohan', 'Rohit', 'Sachin', 'Samir', 'Satish', 'Tushar',
    'Varun', 'Vinod', 'Vishal', 'Yogesh', 'Aakash', 'Bhavesh', 'Chirag', 'Darshan', 'Gaurav', 'Hemant'
];

$lastNames = [
    'Sharma', 'Verma', 'Patel', 'Singh', 'Rathod', 'Kumar', 'Shah', 'Mehta', 'Gupta', 'Yadav',
    'Jain', 'Mishra', 'Trivedi', 'Joshi', 'Desai', 'Kulkarni', 'Reddy', 'Nair', 'Rao', 'Patil',
    'Pawar', 'Shinde', 'Chavan', 'Goel', 'Agarwal', 'Bansal', 'Singhal', 'Mittal', 'Khanna', 'Kapoor',
    'Arora', 'Bhatia', 'Saxena', 'Srivastava', 'Pandey', 'Tiwari', 'Shukla', 'Dubey', 'Chowdhury', 'Das',
    'Bose', 'Sen', 'Iyer', 'Menon', 'Naidu', 'Goud', 'Kadam', 'More', 'Gaikwad', 'Jadhav'
];

// Random name generation
$firstName = $firstNames[array_rand($firstNames)];
$lastName = $lastNames[array_rand($lastNames)];
$phone = (string)rand(6000000000, 9999999999);
$password = 'Pass@@' . rand(1000, 9999);

// Signup data
$signupData = [
    "firstName"    => $firstName,
    "phone"        => $phone,
    "lastName"     => $lastName,
    "password"     => $password,
    "cnfPassword"  => $password
];

$signupJson = json_encode($signupData);

$signupHeaders = [
    'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:144.0) Gecko/20100101 Firefox/144.0',
    'Accept: */*',
    'Accept-Language: en-US,en;q=0.5',
    'Accept-Encoding: gzip, deflate, br, zstd',
    'Content-Type: application/json',
    'Referer: https://app.bulkpe.in/',
    'Origin: https://app.bulkpe.in',
    'Sec-Fetch-Dest: empty',
    'Sec-Fetch-Mode: cors',
    'Sec-Fetch-Site: same-site',
    'Cloudkey: ',
    'Authorization: Bearer',
    'TE: trailers',
    'Content-Length: ' . strlen($signupJson)
];

// Signup API call
$signupUrl = 'https://api.bulkpe.in/api/signup';
$ch = curl_init($signupUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $signupJson);
curl_setopt($ch, CURLOPT_HTTPHEADER, $signupHeaders);
curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_2_0);
curl_setopt($ch, CURLOPT_ENCODING, '');
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);

$responseSignup = curl_exec($ch);
$httpCodeSignup = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$errSignup = curl_error($ch);
curl_close($ch);

if ($errSignup) {
    http_response_code(500);
    echo json_encode([
        "status" => "error",
        "message" => "Signup API request failed",
        "details" => $errSignup
    ], JSON_UNESCAPED_SLASHES);
    exit;
}

if ($httpCodeSignup !== 200) {
    http_response_code($httpCodeSignup);
    echo json_encode([
        "status" => "error",
        "message" => "Signup API returned status code: " . $httpCodeSignup,
        "raw_response" => $responseSignup
    ], JSON_UNESCAPED_SLASHES);
    exit;
}

$decodedSignup = json_decode($responseSignup, true);

if (!is_array($decodedSignup) || empty($decodedSignup['token'])) {
    http_response_code(500);
    echo json_encode([
        "status" => "error",
        "message" => "Failed to obtain authentication token",
        "raw_response" => $responseSignup
    ], JSON_UNESCAPED_SLASHES);
    exit;
}

$token = $decodedSignup['token'];

// Generate email
$separator = ['.', '_', ''][rand(0, 2)];
$email = strtolower($firstName . $separator . $lastName . rand(10, 999) . '@gmail.com');

// Verify PAN
$verifyUrl = "https://api.bulkpe.in/api/verifyKycPanV2";
$payload = [
    "pan" => $pan,
    "kycType" => 2,
    "email" => $email
];

$verifyHeaders = [
    "Accept: */*",
    "Authorization: Bearer " . $token,
    "Content-Type: application/json",
    "Origin: https://app.bulkpe.in",
    "Referer: https://app.bulkpe.in/",
    "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:144.0) Gecko/20100101 Firefox/144.0"
];

$ch2 = curl_init($verifyUrl);
curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch2, CURLOPT_POST, true);
curl_setopt($ch2, CURLOPT_HTTPHEADER, $verifyHeaders);
curl_setopt($ch2, CURLOPT_POSTFIELDS, json_encode($payload));
curl_setopt($ch2, CURLOPT_ENCODING, '');
curl_setopt($ch2, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch2, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($ch2, CURLOPT_TIMEOUT, 30);
curl_setopt($ch2, CURLOPT_CONNECTTIMEOUT, 10);

$responseVerify = curl_exec($ch2);
$httpCodeVerify = curl_getinfo($ch2, CURLINFO_HTTP_CODE);
$errVerify = curl_error($ch2);
curl_close($ch2);

if ($errVerify) {
    http_response_code(500);
    echo json_encode([
        "status" => "error",
        "message" => "PAN verification API request failed",
        "details" => $errVerify
    ], JSON_UNESCAPED_SLASHES);
    exit;
}

$decodedVerify = json_decode($responseVerify, true);

// Handle response
if (isset($decodedVerify['apiStatus']) && $decodedVerify['apiStatus'] === true) {
    if (isset($decodedVerify['result']) && is_array($decodedVerify['result'])) {
        $result = $decodedVerify['result'];

        // Gender mapping (1 = Male, 2 = Female)
        if (isset($result['gender'])) {
            if ($result['gender'] == 1) {
                $result['gender'] = 'Male';
            } elseif ($result['gender'] == 2) {
                $result['gender'] = 'Female';
            } else {
                $result['gender'] = 'N/A';
            }
        }

        // DOB formatting (DD-MM-YYYY)
        if (isset($result['dob'])) {
            try {
                $date = new DateTime($result['dob']);
                $result['dob'] = $date->format('d-m-Y');
            } catch (Exception $e) {
                // Keep original format if parsing fails
            }
        }

        // Remove unwanted keys
        $unwantedKeys = [
            'email', 
            'User', 
            'addressUpdatedFrom', 
            'DocumentVerification', 
            'isAdminAccepted',
            'inviteSent',
            'verificationStatus',
            'business_address'
        ];
        
        foreach ($unwantedKeys as $key) {
            unset($result[$key]);
        }

        $output = [
            "status" => "success",
            "message" => "PAN data found successfully",
            "result" => $result
        ];
    } else {
        $output = [
            "status" => "success",
            "message" => "PAN verified but no additional data available",
            "result" => []
        ];
    }
} else {
    $errorMessage = "PAN not found or verification failed";
    if (isset($decodedVerify['message'])) {
        $errorMessage = $decodedVerify['message'];
    } elseif (isset($decodedVerify['error'])) {
        $errorMessage = $decodedVerify['error'];
    }
    
    $output = [
        "status" => "failed",
        "message" => $errorMessage
    ];
}

echo json_encode($output, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);