<?php
session_start();
define('AHK_NO_LINKS', true);
if (!ob_get_level()) { ob_start(); }
error_reporting(0);
ini_set('display_errors', '0');
include('../includes/config.php');
$isAjax = (isset($_POST['ajax']) && $_POST['ajax'] == '1')
    || (isset($_GET['ajax']) && $_GET['ajax'] == '1')
    || (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest');
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    if ($isAjax) {
        if (ob_get_length()) { ob_clean(); }
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode(['status' => 0, 'message' => 'Invalid request']);
        exit;
    }
    header('Location: /');
    exit;
}
if (empty($upi_merchant_code) || empty($upi_secret)) {
    if (ob_get_length()) { ob_clean(); }
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['status' => 0, 'message' => 'Gateway not configured']);
    exit;
}
$order_id = isset($_POST['order_id']) ? trim($_POST['order_id']) : '';
$phone = isset($_POST['phone']) ? preg_replace('/\D+/', '', $_POST['phone']) : '';
$amount = isset($_POST['amount']) ? (string)$_POST['amount'] : '';
if ($order_id === '' || $phone === '' || $amount === '') {
    if (ob_get_length()) { ob_clean(); }
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['status' => 0, 'message' => 'Missing fields']);
    exit;
}
$_SESSION['reg_order_id'] = $order_id;
$_SESSION['reg_phone'] = $phone;
$data = array(
    "customer_mobile" => $phone,
    "user_token" => $upi_secret,
    "amount" => $amount,
    "order_id" => $order_id,
    "redirect_url" => ((isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . "/pay/regresponse.php",
);
$ch = curl_init();
$cfg = array(
    CURLOPT_URL            => "https://payhere.run.place/api/create-order",
    CURLOPT_POST           => true,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POSTFIELDS     => $data,
    CURLOPT_TIMEOUT        => 20,
);
curl_setopt_array($ch, $cfg);
$response = curl_exec($ch);
$err = curl_error($ch);
curl_close($ch);
if ($response === FALSE) {
    if (ob_get_length()) { ob_clean(); }
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['status' => 0, 'message' => 'Network error', 'error' => $err]);
    exit;
}
$result = json_decode($response, true);
if (is_array($result) && !empty($result['status']) && isset($result['result']['payment_url'])) {
    if (ob_get_length()) { ob_clean(); }
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['status' => 1, 'payment_url' => $result['result']['payment_url']]);
    exit;
}
if (ob_get_length()) { ob_clean(); }
header('Content-Type: application/json; charset=utf-8');
echo json_encode([
    'status' => 0,
    'message' => is_array($result) ? ($result['message'] ?? 'Unknown error') : 'Invalid JSON response'
]);
exit;
