<?php
session_start();
include('../includes/config.php');
header('Content-Type: text/html; charset=utf-8');
echo '<!doctype html><html><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1"><title>Registration Status</title><script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script></head><body><div style="padding:16px;font-family:Arial">Processing, please wait...</div><script>setTimeout(function(){ if (!window.Swal) { window.location.href="/login.php"; } }, 10000);</script>';
if (!isset($_SESSION['reg_order_id']) || !isset($_SESSION['reg_phone'])) {
    echo "<script src=\"https://cdn.jsdelivr.net/npm/sweetalert2@11\"></script><script>Swal.fire('Error','Order missing','error').then(()=>{window.location.href='/login.php';});</script>";
    exit;
}
$order_id = $_SESSION['reg_order_id'];
$phone = $_SESSION['reg_phone'];
if (empty($upi_merchant_code) || empty($upi_secret)) {
    echo "<script src=\"https://cdn.jsdelivr.net/npm/sweetalert2@11\"></script><script>Swal.fire('Gateway','Not configured','warning').then(()=>{window.location.href='/login.php';});</script>";
    exit;
}
$url = "https://payhere.run.place/api/check-order-status";
$postData = array(
    "user_token" => $upi_secret,
    "order_id" => $order_id
);
$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
$response = curl_exec($ch);
if (curl_errno($ch)) {
    echo "<script src=\"https://cdn.jsdelivr.net/npm/sweetalert2@11\"></script><script>Swal.fire('Error','Gateway error','error').then(()=>{window.location.href='/login.php';});</script>";
    exit;
}
curl_close($ch);
$data = json_decode($response, true);
if (!empty($data['status']) && $data['status'] === "COMPLETED") {
    $res = $data['result'] ?? [];
    $status = $res['status'] ?? '';
    $amount = floatval($res['amount'] ?? 0);
    if ($status === "SUCCESS") {
        $safeOrder = mysqli_real_escape_string($ahk_conn, $order_id);
        $sphone = mysqli_real_escape_string($ahk_conn, $phone);
        mysqli_begin_transaction($ahk_conn);
        $ok1 = mysqli_query($ahk_conn, "UPDATE users SET status='1' WHERE order_id='".$safeOrder."' AND phone='".$sphone."'");
        $exw = mysqli_query($ahk_conn, "SELECT id,status FROM wallet WHERE txn_id='".$safeOrder."' LIMIT 1");
        if ($exw && mysqli_num_rows($exw) === 1) {
            $tx = mysqli_fetch_assoc($exw);
            if ($tx['status'] !== 'success') {
                mysqli_query($ahk_conn, "UPDATE wallet SET status='success', RESPMSG='Payment verified', PAYMENTMODE='REGQR' WHERE txn_id='".$safeOrder."'");
            }
        } else {
            mysqli_query($ahk_conn, "INSERT INTO wallet (phone, amount, txn_id, email, status, PAYMENTMODE) VALUES ('".$sphone."', '".$amount."', '".$safeOrder."', '', 'success', 'REGQR')");
        }
        if ($ok1) {
            mysqli_commit($ahk_conn);
            echo "<script src=\"https://cdn.jsdelivr.net/npm/sweetalert2@11\"></script><script>Swal.fire('Success','Registration payment verified. Your account is active.','success').then(()=>{window.location.href='/login.php';});</script>";
            exit;
        } else {
            mysqli_rollback($ahk_conn);
            echo "<script src=\"https://cdn.jsdelivr.net/npm/sweetalert2@11\"></script><script>Swal.fire('Error','Activation failed','error').then(()=>{window.location.href='/login.php';});</script>";
            exit;
        }
    } else {
        echo "<script src=\"https://cdn.jsdelivr.net/npm/sweetalert2@11\"></script><script>Swal.fire('Pending','Payment not completed','warning').then(()=>{window.location.href='/login.php';});</script>";
        exit;
    }
}
echo "<script src=\"https://cdn.jsdelivr.net/npm/sweetalert2@11\"></script><script>Swal.fire('Error','Invalid response','error').then(()=>{window.location.href='/login.php';});</script>";
exit;
