<?php
include('header.php');

$showPdf = false;
$pdfUrl = '';

if (isset($_POST['b2']) && $_POST['b2'] === "Bittu") {
    $dl = mysqli_real_escape_string($ahk_conn, $_POST['dl']);
    $dob = mysqli_real_escape_string($ahk_conn, $_POST['dob']);
    
    // Defaulting these since Blue might not need them, but keeping code structure
    $background = isset($_POST['background']) ? mysqli_real_escape_string($ahk_conn, $_POST['background']) : 'B';
    $card_type = isset($_POST['card_type']) ? mysqli_real_escape_string($ahk_conn, $_POST['card_type']) : 'nochip';

    $application_no = "FLX_" . rand(100000, 999999);
    $type = ($card_type == "chip") ? "2" : "1";
    $color = ($background == "B") ? "true" : "false";

    $price_row = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT price FROM pricing WHERE service_name='Driving_Licence_Pdf'"));
    $fee = $price_row['price'];
    $username = $udata['phone'];
    $wallet = $udata['balance'];

    if ($wallet >= $fee) {
        $debit_fee = $wallet - $fee;
        
        if (empty($new_api_key) || empty($new_api_url)) {
            echo "<script>$(function(){ Swal.fire('System Error', 'New API Configuration Missing', 'error') });</script>";
            exit;
        }

        $base = rtrim($new_api_url, '/');
        // Using dl-pdf-blue service
        $url = "$base/index.php?service=dl-pdf-blue&api_key=" . urlencode($new_api_key) . "&dl_number=" . urlencode($dl) . "&dob=" . urlencode($dob);

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 60,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ]);

        $response = curl_exec($curl);
        $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);
        
        // Normalize New API response
        $resdata = json_decode($response, true);
        
        // Check for success in new API format
        if (isset($resdata['status']) && $resdata['status'] === 'success') {
             // 1. Check for Base64 PDF Data
             if (isset($resdata['data']['data']['pdf']) && !empty($resdata['data']['data']['pdf'])) {
                 $base64 = $resdata['data']['data']['pdf'];
             } elseif (isset($resdata['data']['pdf']) && !empty($resdata['data']['pdf'])) {
                 $base64 = $resdata['data']['pdf'];
             } else {
                 $base64 = null;
             }

             if ($base64) {
                 // Optimization: Save Base64 to local file
                 $fileName = 'DL_Blue_' . time() . '_' . rand(1000, 9999) . '.pdf';
                 $uploadDir = 'dl_pdf/';
                 if (!is_dir($uploadDir)) {
                     mkdir($uploadDir, 0755, true);
                 }
                 $filePath = $uploadDir . $fileName;
                  
                  // Decode and save
                  if (strpos($base64, 'data:application/pdf;base64,') === 0) {
                      $base64_clean = substr($base64, strlen('data:application/pdf;base64,'));
                  } else {
                      $base64_clean = $base64;
                  }
                  
                  $pdfData = base64_decode($base64_clean);
                  if (file_put_contents($filePath, $pdfData)) {
                      $resdata['a4'] = $filePath; 
                      $resdata['is_url'] = true;
                      $resdata['message'] = '';
                      $httpCode = 200;
                  } else {
                      $resdata['a4'] = $base64;
                      $resdata['message'] = '';
                      $httpCode = 200;
                  }
             } elseif (isset($resdata['data']['data']['pdf_url']) && !empty($resdata['data']['data']['pdf_url'])) {
                 $resdata['a4'] = $resdata['data']['data']['pdf_url'];
                 $resdata['is_url'] = true;
                 $resdata['message'] = '';
                 $httpCode = 200;
             } elseif (isset($resdata['data']['pdf_url']) && !empty($resdata['data']['pdf_url'])) {
                 $resdata['a4'] = $resdata['data']['pdf_url'];
                 $resdata['is_url'] = true;
                 $resdata['message'] = '';
                 $httpCode = 200;
             }
        }

        if ($httpCode !== 200 || !$response) {
            echo "<script>
                Swal.fire('API Error', 'Failed to connect to the service. Try again later.', 'error');
                setTimeout(() => { window.location.href = 'DL_Instant_flx_blue'; }, 3000);
            </script>";
        } else {
            if (!$resdata || json_last_error() !== JSON_ERROR_NONE) {
                echo "<script>
                    Swal.fire('Response Error', 'Invalid JSON response from API.', 'error');
                    setTimeout(() => { window.location.href = 'DL_Instant_flx_blue'; }, 3000);
                </script>";
            } elseif (!empty($resdata['message']) && empty($resdata['a4'])) {
                $error = htmlspecialchars($resdata['message']);
                echo "<script>
                    Swal.fire('API Error', '$error', 'warning');
                    setTimeout(() => { window.location.href = 'DL_Instant_flx_blue'; }, 3000);
                </script>";
            } elseif (empty($resdata['a4'])) {
                $keys = isset($resdata['data']) ? implode(',', array_keys($resdata['data'])) : 'no-data';
                $innerKeys = isset($resdata['data']['data']) ? implode(',', array_keys($resdata['data']['data'])) : 'no-inner-data';
                $debugMsg = "Keys: $keys | Inner: $innerKeys. Status: " . ($resdata['status'] ?? 'null');
                
                echo "<script>
                    Swal.fire('PDF Generation Failed', 'The PDF was not generated. $debugMsg', 'error');
                    setTimeout(() => { window.location.href = 'DL_Instant_flx_blue'; }, 10000);
                </script>";
            } else {
                $front = $resdata['front'] ?? '';
                $back = $resdata['back'] ?? '';
                $a4 = $resdata['a4'];
                $is_url = isset($resdata['is_url']) && $resdata['is_url'];

                // Debit the amount
                $debit = mysqli_query($ahk_conn, "UPDATE users SET balance='$debit_fee' WHERE phone='$username'");
                mysqli_query($ahk_conn, "INSERT INTO wallethistory(userid, amount, balance, purpose, status, type) VALUES ('$username','$fee','$debit_fee','Driving Licence Blue PDF','1','Debit')");

                if ($debit) {
                    // Using dlprint2 table
                    $insert = mysqli_query($ahk_conn, "INSERT INTO dlprint2 (application_no, username, dl_no, dob, response, status, fee, front, back, pdf) VALUES ('$application_no','$username','$dl', '$dob', '$response','success', '$fee', '$front','$back','$a4');");

                    if ($insert) {
                        $showPdf = true;
                        if ($is_url) {
                            $pdfUrl = $a4;
                        } else {
                            $pdfUrl = (strpos($a4, 'data:application/pdf;base64,') === 0) ? $a4 : 'data:application/pdf;base64,' . $a4;
                        }

                        echo "<script>
                            Swal.fire('Success', 'DL: $dl downloaded. App No: $application_no', 'success');
                        </script>";
                    }
                }
            }
        }
    } else {
        echo "<script>
            Swal.fire('Insufficient Balance', 'Your wallet balance is low. Please recharge.', 'error');
            setTimeout(() => { window.location.href = 'wallet'; }, 2000);
        </script>";
    }
}
?>


<div class="page-wrapper">
    <div class="page-content">
        <!-- Breadcrumb with Action Buttons -->
        <div class="page-breadcrumb d-flex align-items-center justify-content-between mb-4 p-3 bg-white rounded shadow-sm">
            <div class="d-flex align-items-center">
                <div class="breadcrumb-title pe-3">Services</div>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 ps-2">
                        <li class="breadcrumb-item active text-muted" aria-current="page">Driving Licence Blue</li>
                    </ol>
                </nav>
            </div>
            <div class="btn-group">
                <a href="DL_Instant_flx_blue_list" class="btn btn-success">
                    <i class="bi bi-list-ul me-1"></i> All Blue DL Pdf List
                </a>
                <a href="javascript:history.back()" class="btn btn-outline-primary">
                    <i class="bi bi-arrow-left me-1"></i> Back
                </a>
            </div>
        </div>

        <div class="container-fluid pt-4 px-4">
            <div class="row">
                <!-- Left Side (30%) -->
                <div class="col-lg-4 mb-4">
                    <div class="card">
                        <div class="card-body">
                            <div class="p-3 mb-4 rounded text-white" style="background: linear-gradient(135deg, #0062E6, #33AEFF);">
                                <h3 class="text-center m-0 text-white">
                                    <i class="bi bi-file-earmark-pdf-fill me-2"></i>
                                    <strong>Driving Licence Download (Blue)</strong>
                                </h3>
                            </div>
                            <form method="post" id="dlprint">
                                <div class="form-group mb-3">
                                    <label for="dl">Driving Licence Number</label>
                                    <input type="text" class="form-control" name="dl" required>
                                </div>
                                <div class="form-group mb-3">
                                    <label for="dob">D.O.B</label>
                                    <input type="text" class="form-control" name="dob" placeholder="DD-MM-YYYY" required>
                                </div>
                                <!-- Hidden or Optional inputs for Blue -->
                                <div class="form-group mb-3">
                                    <label for="background">Card Background</label>
                                    <select name="background" class="form-control" required>
                                        <option value="B">Blue</option>
                                    </select>
                                </div>
                                <div class="form-group mb-3">
                                    <label for="card_type">Card Type</label>
                                    <select name="card_type" class="form-control" required>
                                        <option value="nochip">Without Chip</option>
                                        <option value="chip">With Chip</option>
                                    </select>
                                    <input type="hidden" name="b2" value="Bittu">
                                </div>
                                <button type="submit" class="btn btn-primary w-100 d-flex align-items-center justify-content-center" id="submitBtn">
                                    <span id="btnText">Submit</span>
                                    <span id="btnSpinner" class="spinner-border spinner-border-sm d-none ms-2" role="status" aria-hidden="true"></span>
                                </button>
                                <div class="text-center mt-3">
                                    <div class="fee-container">
                                        <h5 class="text-warning">Application Fee:
                                             <?php  
                                                $price = mysqli_fetch_assoc(mysqli_query($ahk_conn,"SELECT price FROM pricing WHERE service_name='Driving_Licence_Pdf'")); 
                                                echo "₹" . $price['price'];
                                            ?>
                                        </h5>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Right Side (70%) PDF Preview -->
                <div class="col-lg-8">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="card-title text-center">PDF Preview</h4>
                            <?php if ($showPdf && $pdfUrl): ?>
                                <div id="pdf-container" class="text-center border p-3 bg-light" style="min-height: 400px;">
                                    <div class="spinner-border text-primary mt-5" role="status" id="pdf-loader">
                                        <span class="visually-hidden">Loading...</span>
                                    </div>
                                </div>
                                
                                <div class="text-center mt-3 no-print">
                                    <button onclick="printCard()" class="btn btn-primary me-2">
                                        <i class="bi bi-printer-fill me-1"></i> Print Card
                                    </button>
                                    <a href="<?php echo $pdfUrl; ?>" download="DL_Blue_Original.pdf" class="btn btn-outline-secondary">
                                        <i class="bi bi-download me-1"></i> Download Original
                                    </a>
                                </div>

                                <!-- PDF.js for rendering -->
                                <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.16.105/pdf.min.js"></script>
                                <script>
                                    pdfjsLib.GlobalWorkerOptions.workerSrc = 'https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.16.105/pdf.worker.min.js';

                                    const url = '<?php echo $pdfUrl; ?>';
                                    const container = document.getElementById('pdf-container');
                                    const loader = document.getElementById('pdf-loader');

                                    pdfjsLib.getDocument(url).promise.then(pdf => {
                                         loader.style.display = 'none';
                                         
                                         // Loop through all pages
                                         for (let pageNum = 1; pageNum <= pdf.numPages; pageNum++) {
                                             // Create wrapper immediately to ensure correct order
                                             const canvasWrapper = document.createElement('div');
                                             canvasWrapper.className = 'mb-4 d-inline-block mx-2';
                                             canvasWrapper.style.border = '1px dashed #ccc';
                                             canvasWrapper.id = 'pdf-page-' + pageNum; // Unique ID
                                             container.appendChild(canvasWrapper);

                                             pdf.getPage(pageNum).then(page => {
                                                 const scale = 3; // High resolution for print
                                                 const viewport = page.getViewport({scale: scale});
                                                 
                                                 const canvas = document.createElement('canvas');
                                                 const context = canvas.getContext('2d');
                                                 canvas.height = viewport.height;
                                                 canvas.width = viewport.width;
                                                 
                                                 // CSS size for display
                                                 canvas.style.width = '85.6mm'; 
                                                 canvas.style.height = 'auto';
                                                 canvas.className = 'pdf-canvas';

                                                 const wrapper = document.getElementById('pdf-page-' + page.pageNumber);
                                                 if(wrapper) {
                                                     wrapper.appendChild(canvas);
                                                 }
                                             });
                                         }
                                    }).catch(error => {
                                        loader.style.display = 'none';
                                        container.innerHTML = '<p class="text-danger">Error loading PDF: ' + error.message + '</p>';
                                    });

                                    function printCard() {
                                        const printWindow = window.open('', '', 'width=800,height=600');
                                        const canvases = document.querySelectorAll('.pdf-canvas');
                                        
                                        let html = '<html><head><title>Print Card</title>';
                                        html += '<style>@media print { body { margin: 0; padding: 0; } img { max-width: 100%; height: auto; page-break-after: always; } }</style>';
                                        html += '</head><body>';
                                        
                                        let loaded = 0;
                                        const total = canvases.length;
                                        
                                        canvases.forEach(canvas => {
                                            const imgData = canvas.toDataURL('image/png');
                                            html += '<img src="' + imgData + '" style="width: 85.6mm; margin: 10px;">';
                                        });
                                        
                                        html += '</body></html>';
                                        
                                        printWindow.document.write(html);
                                        printWindow.document.close();
                                        printWindow.focus();
                                        
                                        // Wait for images to render
                                        setTimeout(() => {
                                            printWindow.print();
                                            printWindow.close();
                                        }, 500);
                                    }
                                </script>
                            <?php else: ?>
                                <div class="text-center py-5 text-muted">
                                    <i class="bi bi-file-earmark-pdf display-1"></i>
                                    <p class="mt-3">Fill the form to generate PDF</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Add loading state to button
    document.getElementById('dlprint').addEventListener('submit', function() {
        const btn = document.getElementById('submitBtn');
        const text = document.getElementById('btnText');
        const spinner = document.getElementById('btnSpinner');
        
        btn.disabled = true;
        text.textContent = 'Processing...';
        spinner.classList.remove('d-none');
    });
</script>

<?php include('footer.php'); ?>
