<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Challan PDF Find - Apply</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .main-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
            padding: 30px;
            margin: 20px auto;
            max-width: 800px;
        }
        .service-header {
            margin-bottom: 25px;
            padding-bottom: 20px;
            border-bottom: 2px dashed #d0d7ff;
        }
        .service-header h2 {
            color: #1f2937;
            font-weight: 700;
            font-size: 1.8rem;
            margin-bottom: 10px;
        }
        .service-header-sub {
            font-size: 0.95rem;
            color: #4b5563;
        }
        .fee-chip {
            background: #fef3c7;
            color: #92400e;
            border-radius: 999px;
            padding: 8px 16px;
            font-size: 0.95rem;
            font-weight: 600;
            border: 1px solid #facc15;
            display: inline-flex;
            align-items: center;
            gap: 6px;
            margin-top: 10px;
        }
        .balance-info {
            background: #f9fafb;
            padding: 12px 18px;
            border-radius: 12px;
            margin-bottom: 20px;
            border: 1px solid #e5e7eb;
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 8px;
            font-size: 0.95rem;
        }
        .balance-info strong {
            color: #111827;
        }
        .balance-tag {
            font-size: 0.85rem;
            background: #ecfdf3;
            color: #15803d;
            padding: 4px 12px;
            border-radius: 999px;
            border: 1px solid #bbf7d0;
        }
        .form-group {
            margin-bottom: 18px;
        }
        .form-group label {
            font-weight: 600;
            color: #333;
            margin-bottom: 8px;
            display: block;
            font-size: 0.95rem;
        }
        .form-control {
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            padding: 12px 15px;
            font-size: 0.95rem;
            transition: all 0.3s;
            background: #f8f9fa;
            text-transform: uppercase;
        }
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
            background: white;
        }
        .btn-submit {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            color: white;
            padding: 12px 30px;
            font-size: 1rem;
            font-weight: 600;
            border-radius: 10px;
            width: 100%;
            transition: all 0.3s;
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(102, 126, 234, 0.5);
            color: white;
        }
        .info-box {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px;
            border-radius: 10px;
            margin-top: 15px;
            text-align: center;
        }
        .info-box i {
            font-size: 1.5rem;
            margin-bottom: 8px;
        }
        .info-box p {
            margin: 5px 0;
            font-size: 0.9rem;
        }
        .text-muted {
            font-size: 0.85rem;
            color: #666;
            margin-top: 5px;
        }
    </style>
</head>
<body>

<?php
include('../header.php');

$service_fee = 30; // ₹30 for all in one panel
$api_key = "enter api key"; // Admin API Key
$api_url = "https://lostdata.co.in/api/challan-pdf-find.php";

$success = false;
$error = '';
$wallet_old_balance = floatval($udata['balance'] ?? 0);
$wallet_new_balance = $wallet_old_balance;
$application_data = null;

if (isset($_POST['apply'])) {
    $bike_number = strtoupper(trim($_POST['bike_number'] ?? ''));
    $bike_number_clean = preg_replace('/[^A-Z0-9-]/', '', $bike_number);
    
    if (empty($bike_number_clean)) {
        $error = "Please enter bike/vehicle number";
    } elseif (strlen($bike_number_clean) < 5 || strlen($bike_number_clean) > 15) {
        $error = "Invalid bike number format (5-15 characters)";
    } else {
        $appliedby = $udata['phone'];
        $wallet_amount = floatval($udata['balance'] ?? 0);
        
        // Check wallet balance
        if ($wallet_amount < $service_fee) {
            $error = "Insufficient balance. Required: ₹$service_fee | Available: ₹" . number_format($wallet_amount, 2);
        } else {
            // Deduct from all in one wallet FIRST
            $nbal = $wallet_amount - $service_fee;
            $debit = mysqli_query(
                $ahk_conn,
                "UPDATE users SET balance=balance-$service_fee WHERE phone='$appliedby'"
            );
            
            if (!$debit) {
                $error = "Wallet deduction failed";
            } else {
                // Log transaction
                mysqli_query($ahk_conn, "INSERT INTO wallethistory
                    (userid,amount,balance,purpose,status,type)
                    VALUES
                    ('$appliedby','$service_fee','$nbal',
                     'Challan PDF Find - Bike: $bike_number_clean','1','Debit')");
                
                // Call API (API will charge ₹20 from API user's wallet)
                $postData = [
                    'api_key' => $api_key,
                    'bike_number' => $bike_number_clean
                ];
                
                $ch = curl_init();
                curl_setopt_array($ch, [
                    CURLOPT_URL => $api_url,
                    CURLOPT_POST => true,
                    CURLOPT_POSTFIELDS => http_build_query($postData),
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_TIMEOUT => 30,
                    CURLOPT_SSL_VERIFYPEER => false
                ]);
                
                $response = curl_exec($ch);
                $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                $curl_error = curl_error($ch);
                curl_close($ch);
                
                $result = json_decode($response, true);
                $api_success = isset($result['success']) && $result['success'] === true;
                
                if ($curl_error || !$api_success || $http_code != 200) {
                    // API failed - refund to all in one wallet
                    mysqli_query($ahk_conn,
                        "UPDATE users SET balance=balance+$service_fee WHERE phone='$appliedby'"
                    );
                    
                    mysqli_query($ahk_conn, "INSERT INTO wallethistory
                        (userid,amount,balance,purpose,status,type)
                        VALUES
                        ('$appliedby','$service_fee','$wallet_amount',
                         'Challan PDF Find Refund - API Failed','1','Credit')");
                    
                    $error_msg = $result['error'] ?? $result['message'] ?? "API call failed";
                    $error = "Application submission failed: $error_msg. Amount refunded.";
                } else {
                    // Success
                    $success = true;
                    $application_data = $result['application'] ?? null;
                    $wallet_new_balance = $nbal;
                    
                    // Refresh balance
                    $fresh_user = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT balance FROM users WHERE phone='$appliedby'"));
                    $wallet_new_balance = floatval($fresh_user['balance'] ?? $nbal);
                }
            }
        }
    }
}

// Refresh user balance
$fresh_user = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT balance FROM users WHERE phone='{$udata['phone']}'"));
$user_balance = floatval($fresh_user['balance'] ?? $udata['balance'] ?? 0);
?>

<div class="main-card">
    <div class="service-header">
        <h2><i class="fas fa-file-pdf text-danger me-2"></i>Challan PDF Find</h2>
        <div class="service-header-sub">
            Find and download challan PDFs without OTP. Operator will upload PDFs within 10-60 minutes.
        </div>
        <div class="fee-chip">
            <i class="fas fa-indian-rupee-sign"></i>
            <span>Service Charge: ₹<?php echo number_format($service_fee, 2); ?></span>
        </div>
    </div>
    
    <div class="balance-info">
        <div>
            <strong><i class="fas fa-wallet me-2"></i>Your Wallet Balance:</strong>
            ₹<?php echo number_format($user_balance, 2); ?>
        </div>
        <div class="balance-tag">
            <i class="fas fa-info-circle me-1"></i>Amount will be auto-debited on successful submit
        </div>
    </div>
    
    <?php if($success): ?>
        <script>
        Swal.fire({
            icon: 'success',
            title: 'Application Submitted!',
            html: '<div style="text-align:left;">' +
                  '<p><strong>Application ID:</strong> #<?php echo $application_data['id'] ?? 'N/A'; ?></p>' +
                  '<p><strong>Bike Number:</strong> <?php echo htmlspecialchars($bike_number_clean ?? ''); ?></p>' +
                  '<p><strong>Status:</strong> <span class="badge bg-warning">Pending</span></p>' +
                  '<p><strong>Old Balance:</strong> ₹<?php echo number_format($wallet_old_balance, 2); ?></p>' +
                  '<p><strong>Deducted:</strong> ₹<?php echo number_format($service_fee, 2); ?></p>' +
                  '<p><strong>New Balance:</strong> ₹<?php echo number_format($wallet_new_balance, 2); ?></p>' +
                  '<p class="mt-3"><strong>📱 Operator will upload PDFs within 10-60 minutes.</strong></p>' +
                  '</div>',
            confirmButtonText: 'View Applications',
            confirmButtonColor: '#667eea'
        }).then(() => {
            window.location.href = 'challan-pdf-find-list.php';
        });
        </script>
    <?php endif; ?>
    
    <?php if($error): ?>
        <div class="alert alert-danger mb-3">
            <i class="fas fa-exclamation-triangle me-2"></i><?php echo htmlspecialchars($error); ?>
        </div>
    <?php endif; ?>
    
    <form method="POST" action="">
        <div class="form-group">
            <label><i class="fas fa-motorcycle me-2"></i>Bike/Vehicle Number <span class="text-danger">*</span></label>
            <input type="text" name="bike_number" class="form-control" 
                   placeholder="e.g., HR26AB1234" required 
                   pattern="[A-Z0-9-]+" 
                   value="<?php echo isset($_POST['bike_number']) ? htmlspecialchars($_POST['bike_number']) : ''; ?>">
            <small class="text-muted">
                <i class="fas fa-info-circle me-1"></i>Enter vehicle registration number (uppercase, alphanumeric)
            </small>
        </div>
        
        <div class="info-box">
            <i class="fas fa-info-circle"></i>
            <p class="mb-0"><strong>Service Charge:</strong> ₹<?php echo number_format($service_fee, 2); ?></p>
            <small>Amount will be deducted from your wallet</small>
            <p class="mb-0 mt-2" style="font-size: 0.9rem;">
                📱 Operator will upload 1-5 PDFs within 10-60 minutes. You can download them from the list page.
            </p>
        </div>
        
        <button type="submit" name="apply" class="btn btn-submit mt-3">
            <i class="fas fa-paper-plane me-2"></i>Submit Application
        </button>
    </form>
    
    <div class="text-center mt-4">
        <a href="challan-pdf-find-list.php" class="text-decoration-none">
            <i class="fas fa-list me-1"></i>View My Applications
        </a>
    </div>
</div>

<script>
// Auto uppercase bike number
document.querySelector('input[name="bike_number"]').addEventListener('input', function(e) {
    this.value = this.value.toUpperCase().replace(/[^A-Z0-9-]/g, '');
});
</script>

<?php include('../footer.php'); ?>
</body>
</html>
