<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Challan PDF Find Applications - Lost Data Solutions</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
</head>
<body>

<?php
include('../header.php');

$username = $udata['phone'];

// Get API key for main website
$api_key = "enter api key"; // Admin API Key
$api_url = "https://lostdata.co.in/api/challan-pdf-find-status.php";

// Fetch applications from API (Main Website Database) - Filter by current user's phone/username
// Note: API will filter by API user's applications, so we need to use admin API key
// and pass username to filter (if API supports it)
$url = $api_url . "?api_key=" . urlencode($api_key);

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_SSL_VERIFYPEER => false
]);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curl_error = curl_error($ch);
curl_close($ch);

$applications_data = [];
$stats = ['total' => 0, 'pending' => 0, 'approved' => 0, 'rejected' => 0];
$api_error = '';
$debug_info = '';

if ($curl_error) {
    $api_error = "cURL Error: $curl_error";
    $debug_info = "URL: $url | cURL Error: $curl_error";
} elseif ($http_code == 200 && !empty($response)) {
    $result = json_decode($response, true);
    if (isset($result['success']) && $result['success'] === true) {
        $all_apps = $result['data'] ?? [];
        
        // Filter applications (if needed - API might already filter by API user)
        // For now, we'll show all applications returned by API
        // In production, API should filter by API user automatically
        $applications_data = $all_apps;
        
        // Calculate stats
        foreach ($applications_data as $app) {
            $stats['total']++;
            $status = strtolower($app['status'] ?? 'pending');
            if ($status === 'pending') {
                $stats['pending']++;
            } elseif (in_array($status, ['approved', 'completed'])) {
                $stats['approved']++;
            } elseif ($status === 'rejected') {
                $stats['rejected']++;
            }
        }
        
        $debug_info = "Success: Found " . count($applications_data) . " applications";
    } else {
        $api_error = $result['error'] ?? $result['message'] ?? 'Unknown API error';
        $debug_info = "API Response: " . substr($response, 0, 200);
    }
} else {
    $api_error = "API Error: HTTP Code $http_code";
    if (!empty($response)) {
        $error_result = json_decode($response, true);
        $api_error .= ' - ' . ($error_result['error'] ?? $error_result['message'] ?? 'No response');
        $debug_info = "Response: " . substr($response, 0, 500);
    } else {
        $debug_info = "No response from API";
    }
}
?>

<div class="page-wrapper">
<div class="page-content">
<div class="card">
<div class="card-body">

<div class="d-flex justify-content-between align-items-center mb-3">
    <h4><i class="fas fa-history me-2"></i>Challan PDF Find Applications</h4>
    <a href="challan-pdf-find-apply.php" class="btn btn-primary">
        <i class="fas fa-plus me-1"></i>New Application
    </a>
</div>

<!-- Statistics -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body text-center">
                <h3><?php echo $stats['total']; ?></h3>
                <p class="mb-0">Total Applications</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-warning text-dark">
            <div class="card-body text-center">
                <h3><?php echo $stats['pending']; ?></h3>
                <p class="mb-0">Pending</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body text-center">
                <h3><?php echo $stats['approved']; ?></h3>
                <p class="mb-0">Approved</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-danger text-white">
            <div class="card-body text-center">
                <h3><?php echo $stats['rejected']; ?></h3>
                <p class="mb-0">Rejected</p>
            </div>
        </div>
    </div>
</div>

<?php if($api_error): ?>
    <div class="alert alert-danger">
        <i class="fas fa-exclamation-triangle me-2"></i>
        <strong>API Error:</strong> <?php echo htmlspecialchars($api_error); ?>
        <?php if($debug_info): ?>
            <br><small>Debug: <?php echo htmlspecialchars($debug_info); ?></small>
        <?php endif; ?>
    </div>
<?php endif; ?>

<?php if(count($applications_data) == 0 && !$api_error): ?>
    <div class="alert alert-info">
        <i class="fas fa-info-circle me-2"></i>
        No applications found.
        <br><small>If you just applied, please wait a moment and refresh the page.</small>
    </div>
<?php endif; ?>

<?php if(count($applications_data) > 0): ?>
    <div class="table-responsive">
        <table class="table table-hover table-striped" id="applicationsTable">
            <thead class="table-dark">
                <tr>
                    <th>ID</th>
                    <th>Bike Number</th>
                    <th>Status</th>
                    <th>PDFs</th>
                    <th>Fee</th>
                    <th>Applied Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($applications_data as $app): 
                    $app_id = $app['id'] ?? 0;
                    $bike_number = htmlspecialchars($app['bike_number'] ?? 'N/A');
                    $status = strtolower($app['status'] ?? 'pending');
                    $pdf_count = $app['pdf_count'] ?? 0;
                    $api_fee = (float)($app['fee'] ?? 0); // API side fee (₹20)
                    $panel_fee = 30; // All-in-one wallet fee (₹30)
                    $created_at = $app['created_at'] ?? '';
                    
                    // Status badge
                    $status_class = 'warning';
                    $status_text = ucfirst($status);
                    if ($status === 'approved' || $status === 'completed') {
                        $status_class = 'success';
                    } elseif ($status === 'rejected') {
                        $status_class = 'danger';
                    }
                ?>
                <tr>
                    <td>#<?php echo $app_id; ?></td>
                    <td><strong><?php echo $bike_number; ?></strong></td>
                    <td>
                        <span class="badge bg-<?php echo $status_class; ?>">
                            <?php echo $status_text; ?>
                        </span>
                    </td>
                    <td>
                        <span class="badge bg-info"><?php echo $pdf_count; ?>/5 PDF(s)</span>
                    </td>
                    <td>
                        <strong>₹<?php echo number_format($panel_fee, 2); ?></strong>
                    </td>
                    <td><?php echo $created_at ? date('d M Y, h:i A', strtotime($created_at)) : 'N/A'; ?></td>
                    <td>
                        <?php if($pdf_count > 0): ?>
                            <button class="btn btn-sm btn-info" onclick="viewDetails(<?php echo $app_id; ?>)">
                                <i class="fas fa-eye"></i> View PDFs
                            </button>
                        <?php else: ?>
                            <span class="text-muted">
                                <i class="fas fa-clock"></i> Waiting...
                            </span>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
<?php endif; ?>

</div>
</div>
</div>
</div>

<!-- View Details Modal -->
<div class="modal fade" id="detailsModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="fas fa-file-pdf me-2"></i>PDF Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="modalBody">
                <div class="text-center">
                    <div class="spinner-border" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>

<script>
$(document).ready(function() {
    $('#applicationsTable').DataTable({
        order: [[0, 'desc']],
        pageLength: 10,
        language: {
            search: "Search:",
            lengthMenu: "Show _MENU_ entries",
            info: "Showing _START_ to _END_ of _TOTAL_ entries",
            paginate: {
                first: "First",
                last: "Last",
                next: "Next",
                previous: "Previous"
            }
        }
    });
});

function viewDetails(appId) {
    $('#detailsModal').modal('show');
    $('#modalBody').html('<div class="text-center"><div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div></div>');
    
    // Fetch PDF details from API
    var apiUrl = 'https://lostdata.co.in/api/challan-pdf-find-status.php?api_key=<?php echo urlencode($api_key); ?>&app_id=' + appId;
    
    $.ajax({
        url: apiUrl,
        method: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.success && response.application) {
                var app = response.application;
                var pdfs = app.pdfs || [];
                
                var html = '<div class="mb-3">';
                html += '<p><strong>Application ID:</strong> #' + app.id + '</p>';
                html += '<p><strong>Bike Number:</strong> ' + (app.bike_number || 'N/A') + '</p>';
                html += '<p><strong>Status:</strong> <span class="badge bg-' + (app.status === 'approved' ? 'success' : 'warning') + '">' + (app.status || 'pending') + '</span></p>';
                html += '<p><strong>PDFs Uploaded:</strong> ' + pdfs.length + '</p>';
                html += '</div>';
                
                if (pdfs.length > 0) {
                    html += '<div class="list-group">';
                    pdfs.forEach(function(pdf, index) {
                        html += '<div class="list-group-item d-flex justify-content-between align-items-center">';
                        html += '<div>';
                        html += '<strong>PDF ' + (pdf.pdf_number || (index + 1)) + '</strong><br>';
                        html += '<small class="text-muted">Uploaded: ' + (pdf.uploaded_at || 'N/A') + '</small>';
                        html += '</div>';
                        html += '<a href="' + (pdf.pdf_url || pdf.pdf_path || '#') + '" class="btn btn-sm btn-primary" target="_blank" download>';
                        html += '<i class="fas fa-download me-1"></i>Download';
                        html += '</a>';
                        html += '</div>';
                    });
                    html += '</div>';
                } else {
                    html += '<div class="alert alert-info">No PDFs uploaded yet. Please wait for operator to upload.</div>';
                }
                
                $('#modalBody').html(html);
            } else {
                $('#modalBody').html('<div class="alert alert-danger">Failed to load PDF details: ' + (response.message || 'Unknown error') + '</div>');
            }
        },
        error: function(xhr, status, error) {
            $('#modalBody').html('<div class="alert alert-danger">Error loading PDF details: ' + error + '</div>');
        }
    });
}
</script>

</body>
</html>
