<?php
// DBT Aadhaar Verify - All in One Apply Page

// Output buffering & basic setup
ob_start();
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

session_start();
include("../header.php"); // gives $ahk_conn, $udata etc.

// Safety check for DB connection
if (!isset($ahk_conn) || !$ahk_conn) {
    ob_end_clean();
    die("Database connection error");
}
ob_end_clean();

// Logged in user (all in one panel user)
$panel_phone = $udata['phone'] ?? null;
if (!$panel_phone) {
    header("Location: ../login.php");
    exit();
}

// Wallet & result variables
$service_price = 30; // ₹30 per DBT Aadhaar verify in this panel
$error = "";
$success = "";
$result_data = null;
$wallet_old_balance = 0;
$wallet_new_balance = 0;
$wallet_deducted = 0;
$aadhaar_input = "";

// Helper: get fresh wallet balance
function get_panel_wallet_balance($conn, $phone) {
    $phone_safe = mysqli_real_escape_string($conn, $phone);
    $res = mysqli_query($conn, "SELECT balance FROM users WHERE phone='$phone_safe' LIMIT 1");
    if ($res && mysqli_num_rows($res) > 0) {
        $row = mysqli_fetch_assoc($res);
        return (float)$row['balance'];
    }
    return 0.0;
}

// Helper: deduct from panel wallet (only from this all-in-one DB)
function panel_wallet_debit($conn, $phone, $amount, $purpose) {
    $phone_safe = mysqli_real_escape_string($conn, $phone);
    $amount = (float)$amount;
    $apply_time = date("Y-m-d H:i:s");

    mysqli_begin_transaction($conn);
    try {
        // Deduct if sufficient balance
        $upd = mysqli_query(
            $conn,
            "UPDATE users SET balance = balance - $amount 
             WHERE phone = '$phone_safe' AND balance >= $amount"
        );
        if (!$upd || mysqli_affected_rows($conn) === 0) {
            throw new Exception("Insufficient balance or update failed");
        }

        // Get new balance and log in wallethistory (same style as without-apply)
        $new_balance = get_panel_wallet_balance($conn, $phone_safe);
        $purpose_safe = mysqli_real_escape_string($conn, $purpose);
        mysqli_query(
            $conn,
            "INSERT INTO wallethistory (userid, amount, balance, purpose, status, type)
             VALUES ('$phone_safe', '$amount', '$new_balance', '$purpose_safe', '1', 'Debit')"
        );

        mysqli_commit($conn);
        return $new_balance;
    } catch (Exception $e) {
        @mysqli_rollback($conn);
        return false;
    }
}

// External LostData API config
$external_api_url = "https://lostdata.co.in/api/dbt-aadhaar-verify.php";
$external_api_key = "enter api key";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $aadhaar_input = trim($_POST['aadhaar'] ?? '');

    // Basic validation: 12-digit Aadhaar
    $aadhaar_clean = preg_replace('/[^0-9]/', '', $aadhaar_input);

    if (empty($aadhaar_clean)) {
        $error = "Aadhaar number is required / आधार संख्या आवश्यक है";
    } elseif (!preg_match('/^[0-9]{12}$/', $aadhaar_clean)) {
        $error = "Invalid Aadhaar number. Please enter 12 digits / अमान्य आधार संख्या (12 अंक दर्ज करें)";
    } else {
        // Check wallet balance before calling API
        $current_balance = get_panel_wallet_balance($ahk_conn, $panel_phone);
        if ($current_balance < $service_price) {
            $error = "Insufficient balance. Need ₹$service_price / बैलेंस कम है, ₹$service_price चाहिए";
        } else {
            $wallet_old_balance = $current_balance;

            // Call external API FIRST – no local deduction yet
            $api_url = $external_api_url . "?api_key=" . urlencode($external_api_key) . "&aadhaar=" . urlencode($aadhaar_clean);

            $ch = curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => $api_url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_TIMEOUT => 40,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_FOLLOWLOCATION => true
            ]);

            $response = curl_exec($ch);
            $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $curl_error = curl_error($ch);
            curl_close($ch);

            if ($curl_error) {
                $error = "Connection error: " . $curl_error . " / कनेक्शन त्रुटि";
            } elseif ($http_code != 200) {
                $error = "API HTTP $http_code / API त्रुटि ($http_code)";
            } else {
                $api_data = json_decode($response, true);
                if (json_last_error() !== JSON_ERROR_NONE) {
                    $error = "Invalid API response / अमान्य API प्रतिक्रिया";
                } else {
                    // Check success conditions from sample:
                    // {"success":true,"statuscode":200,"dbt_data":{"status":true,...}}
                    $is_success = (
                        isset($api_data['success']) && $api_data['success'] === true &&
                        isset($api_data['statuscode']) && (int)$api_data['statuscode'] === 200 &&
                        isset($api_data['dbt_data']['status']) && $api_data['dbt_data']['status'] === true
                    );

                    if ($is_success) {
                        // Now deduct ₹30 from panel wallet
                        $purpose_text = "DBT Aadhaar Verify (₹$service_price) - Aadhaar: " . $aadhaar_clean;
                        $new_balance = panel_wallet_debit($ahk_conn, $panel_phone, $service_price, $purpose_text);

                        if ($new_balance === false) {
                            $error = "Wallet deduction failed / वॉलेट से राशि नहीं कट पाई, कृपया दोबारा प्रयास करें";
                        } else {
                            $wallet_deducted = $service_price;
                            $wallet_new_balance = $new_balance;
                            $result_data = $api_data;
                            $success = "DBT status fetched successfully! / DBT स्थिति सफलतापूर्वक प्राप्त हुई!";
                        }
                    } else {
                        // API failure – no local deduction
                        $msg = $api_data['verify_data']['message'] ??
                               $api_data['dbt_data']['message'] ??
                               $api_data['message'] ??
                               "DBT status not found / DBT स्थिति नहीं मिली";
                        $error = $msg;
                    }
                }
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>DBT Aadhaar Verify / DBT आधार जांच</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        *{margin:0;padding:0;box-sizing:border-box;}
        body{
            font-family:'Poppins',sans-serif;
            background:#f1f3f6;
            min-height:100vh;
            padding:15px;
        }
        .container-custom{
            max-width:960px;
            margin:15px auto;
        }
        .card-custom{
            background:#fff;
            border-radius:18px;
            box-shadow:0 18px 40px rgba(15,23,42,0.15);
            border:1px solid #e5e7eb;
            overflow:hidden;
        }
        .card-header-custom{
            padding:20px 24px 16px;
            border-bottom:1px solid #e5e7eb;
            display:flex;
            flex-direction:column;
            gap:8px;
            background:linear-gradient(135deg,#1d4ed8 0%,#1e40af 100%);
            color:#fff;
        }
        .header-title-row{
            display:flex;
            justify-content:space-between;
            align-items:center;
            flex-wrap:wrap;
            gap:10px;
        }
        .header-left{
            display:flex;
            align-items:center;
            gap:10px;
        }
        .header-icon{
            width:44px;
            height:44px;
            border-radius:50%;
            background:rgba(15,23,42,0.35);
            display:flex;
            align-items:center;
            justify-content:center;
            font-size:20px;
        }
        .header-text h3{
            margin:0;
            font-size:1.4rem;
            font-weight:700;
        }
        .header-text p{
            margin:2px 0 0;
            font-size:0.85rem;
            opacity:0.9;
        }
        .fee-badge{
            background:#fef3c7;
            color:#92400e;
            padding:6px 14px;
            border-radius:999px;
            font-size:0.9rem;
            font-weight:600;
            border:1px solid #facc15;
            display:flex;
            align-items:center;
            gap:6px;
        }
        .card-body-custom{
            padding:22px 24px 24px;
        }
        .wallet-box{
            background:#f9fafb;
            border-radius:12px;
            padding:10px 16px;
            border:1px solid #e5e7eb;
            display:flex;
            align-items:center;
            justify-content:space-between;
            gap:8px;
            margin-bottom:18px;
            font-size:0.9rem;
        }
        .wallet-pill{
            background:#ecfdf3;
            color:#15803d;
            border-radius:999px;
            padding:4px 10px;
            font-size:0.8rem;
            border:1px solid #bbf7d0;
        }
        .info-strip{
            background:#eff6ff;
            border-radius:10px;
            padding:12px 14px;
            border-left:4px solid #2563eb;
            font-size:0.85rem;
            margin-bottom:18px;
        }
        .info-strip ul{
            margin:6px 0 0;
            padding-left:18px;
        }
        .info-strip li{
            margin-bottom:4px;
        }
        .form-control{
            border-radius:10px;
            padding:11px 14px;
            border:2px solid #e5e7eb;
        }
        .form-control:focus{
            border-color:#2563eb;
            box-shadow:0 0 0 0.15rem rgba(37,99,235,0.25);
        }
        .btn-primary{
            background:linear-gradient(135deg,#2563eb 0%,#1d4ed8 100%);
            border:none;
            padding:11px 26px;
            border-radius:10px;
            font-weight:600;
            width:100%;
        }
        .btn-primary:hover{
            transform:translateY(-1px);
            box-shadow:0 6px 16px rgba(37,99,235,0.4);
        }
        .result-box{
            margin-top:20px;
            background:linear-gradient(135deg,#d1fae5 0%,#bbf7d0 100%);
            border-radius:12px;
            padding:16px 16px 14px;
            border:1px solid #6ee7b7;
        }
        .result-inner{
            background:#fff;
            border-radius:10px;
            padding:14px 16px;
            border-left:4px solid #10b981;
            font-size:0.9rem;
        }
        .fade-hint{
            font-size:0.8rem;
            color:#065f46;
            margin-top:6px;
        }
        .alert{
            border-radius:10px;
        }
    </style>
</head>
<body>
    <div class="container-custom">
        <div class="card-custom">
            <div class="card-header-custom">
                <div class="header-title-row">
                    <div class="header-left">
                        <div class="header-icon">
                            <i class="fas fa-university"></i>
                        </div>
                        <div class="header-text">
                            <h3>DBT Aadhaar Verify / DBT आधार सत्यापन</h3>
                            <p>Check if Aadhaar is linked and eligible for DBT in bank.</p>
                        </div>
                    </div>
                    <div class="fee-badge">
                        <i class="fas fa-indian-rupee-sign"></i>
                        <span>Service Charge: ₹<?php echo number_format($service_price, 2); ?></span>
                    </div>
                </div>
            </div>
            <div class="card-body-custom">
                <div class="wallet-box">
                    <div>
                        <strong><i class="fas fa-wallet me-1"></i>Wallet Balance:</strong>
                        ₹<?php echo number_format(get_panel_wallet_balance($ahk_conn, $panel_phone), 2); ?>
                    </div>
                    <div class="wallet-pill">
                        <i class="fas fa-info-circle me-1"></i>₹<?php echo $service_price; ?> कटेगा केवल सफल DBT पर
                    </div>
                </div>

                <?php if (!empty($error)): ?>
                    <div class="alert alert-danger">
                        <i class="fas fa-exclamation-circle"></i>
                        <span><?php echo htmlspecialchars($error); ?></span>
                    </div>
                <?php endif; ?>

                <?php if (!empty($success)): ?>
                    <div class="alert alert-success">
                        <i class="fas fa-check-circle"></i>
                        <span><?php echo htmlspecialchars($success); ?></span>
                    </div>
                <?php endif; ?>

                <div class="info-strip">
                    <strong><i class="fas fa-lightbulb me-1"></i>Important / महत्वपूर्ण:</strong>
                    <ul>
                        <li>Service charge ₹<?php echo $service_price; ?> आपके वॉलेट से केवल सफल DBT मिलने पर कटेगा।</li>
                        <li>यदि DBT जानकारी नहीं मिलती, तो आपके वॉलेट से कोई राशि नहीं कटेगी।</li>
                        <li>कृपया सही 12 अंकों की Aadhaar संख्या दर्ज करें।</li>
                    </ul>
                </div>

                <form method="POST" action="">
                    <div class="mb-3">
                        <label for="aadhaar" class="form-label">
                            <i class="fas fa-fingerprint me-1"></i>
                            Aadhaar Number / आधार संख्या *
                        </label>
                        <input
                            type="text"
                            class="form-control"
                            id="aadhaar"
                            name="aadhaar"
                            placeholder="Enter 12-digit Aadhaar number / 12 अंकों की आधार संख्या दर्ज करें"
                            maxlength="14"
                            required
                            value="<?php echo htmlspecialchars($aadhaar_input); ?>">
                        <small class="text-muted">
                            केवल संख्या दर्ज करें, आप बीच में space भी लिख सकते हैं (उदाहरण: 6560 0712 1286)
                        </small>
                    </div>

                    <button type="submit" class="btn btn-primary mt-2">
                        <i class="fas fa-search me-1"></i> Check DBT Status / DBT स्थिति जांचें
                    </button>
                </form>

                <?php if ($result_data && isset($result_data['dbt_data'])): ?>
                    <?php $dbt = $result_data['dbt_data']; ?>
                    <div class="result-box">
                        <h6 class="mb-2">
                            <i class="fas fa-receipt me-1"></i> DBT Result / DBT परिणाम
                        </h6>
                        <div class="result-inner">
                            <p><strong>Aadhaar:</strong> <?php echo htmlspecialchars($result_data['uid'] ?? $aadhaar_clean); ?></p>
                            <p><strong>Bank:</strong> <?php echo htmlspecialchars($dbt['bank'] ?? 'N/A'); ?></p>
                            <p><strong>Status:</strong>
                                <?php echo !empty($dbt['status']) ? '✅ Active / DBT Available' : '❌ Not Active / DBT Not Found'; ?>
                            </p>
                            <p><strong>Message:</strong> <?php echo htmlspecialchars($dbt['message'] ?? ''); ?></p>

                            <hr class="my-2">
                            <p class="mb-1"><strong>Wallet Details / वॉलेट विवरण:</strong></p>
                            <p class="mb-0">
                                Old Balance: ₹<?php echo number_format($wallet_old_balance, 2); ?> &nbsp; |
                                Deducted: ₹<?php echo number_format($wallet_deducted, 2); ?> &nbsp; |
                                New Balance: ₹<?php echo number_format($wallet_new_balance, 2); ?>
                            </p>
                        </div>
                        <div class="fade-hint">
                            <i class="fas fa-clock me-1"></i>
                            यह स्क्रीन 1 मिनट बाद अपने आप बंद हो जाएगी / This result will auto-hide after 1 minute.
                        </div>
                    </div>
                    <script>
                        // Auto-hide result after 60 seconds
                        setTimeout(function () {
                            window.location.href = 'dbt-aadhaar-verify.php';
                        }, 60000);
                    </script>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script>
        // Restrict Aadhaar input to digits and spaces only
        document.addEventListener('DOMContentLoaded', function () {
            var aadhaarInput = document.getElementById('aadhaar');
            if (aadhaarInput) {
                aadhaarInput.addEventListener('input', function () {
                    this.value = this.value.replace(/[^0-9\s]/g, '');
                });
            }
        });
    </script>

    <?php include("../footer.php"); ?>
</body>
</html>

