<?php
// All-in-one Farmer PDF Download (wallet ₹30, only on successful PDF)

error_reporting(0);
ini_set('display_errors', 0);

// All-in-one panel already handles session + auth inside header.php
include('../header.php'); // provides $ahk_conn, $udata, $sdata etc.

// Panel user identification (same style as other all-in-one pages)
$panel_phone = $udata['phone'];
$service_charge = 30; // ₹30 per download from ALL IN ONE wallet

// Helper: get fresh wallet balance
function get_panel_balance($conn, $phone) {
    $phone_safe = mysqli_real_escape_string($conn, $phone);
    $res = mysqli_query($conn, "SELECT balance FROM users WHERE phone='$phone_safe' LIMIT 1");
    if ($res && mysqli_num_rows($res) > 0) {
        $row = mysqli_fetch_assoc($res);
        return (float)$row['balance'];
    }
    return 0.0;
}

// Current balance
$wallet_balance = get_panel_balance($ahk_conn, $panel_phone);
$balance_after  = $wallet_balance - $service_charge;

/* ========== DOWNLOAD HANDLER (AJAX/iframe POST) ========== */
if (isset($_POST['download_pdf'])) {
    $uid   = trim($_POST['uid'] ?? '');
    $state = trim($_POST['state'] ?? '');

    header('Content-Type: application/json'); // default; will override for real PDF

    if ($uid === '' || $state === '') {
        echo json_encode(["status" => false, "message" => "Missing UID or state"]);
        exit;
    }

    if (!preg_match('/^[0-9]{12}$/', $uid)) {
        echo json_encode(["status" => false, "message" => "Invalid UID (must be 12 digits)"]);
        exit;
    }

    // Re-check balance
    $current_balance = get_panel_balance($ahk_conn, $panel_phone);
    if ($current_balance < $service_charge) {
        echo json_encode(["status" => false, "message" => "Insufficient balance"]);
        exit;
    }

    // External Farmer PDF API (LostData) - will charge its own wallet separately
    $hidden_api_key = "enter api key";
    $apiUrl =
        "https://lostdata.co.in/api/farmer.php"
        . "?api_key=" . $hidden_api_key
        . "&uid=" . urlencode($uid)
        . "&state=" . urlencode($state)
        . "&download=1";

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $apiUrl,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_TIMEOUT => 60,
        CURLOPT_FOLLOWLOCATION => true
    ]);

    $pdf = curl_exec($ch);
    $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curl_error = curl_error($ch);
    curl_close($ch);

    // Handle cURL/HTTP errors (NO wallet deduction)
    if ($curl_error) {
        echo json_encode(["status" => false, "message" => "Connection error: " . $curl_error]);
        exit;
    }

    if ($http != 200 || !$pdf) {
        echo json_encode(["status" => false, "message" => "API returned HTTP $http"]);
        exit;
    }

    // Detect non-PDF response (JSON/HTML error)
    $trimmed = trim($pdf);
    $first_char = substr($trimmed, 0, 1);
    if ($first_char === '{' || $first_char === '<') {
        $error_data = @json_decode($pdf, true);
        if ($error_data) {
            $error_msg = $error_data['message'] ?? $error_data['error'] ?? 'PDF generation failed';
        } else {
            $error_msg = 'Server returned invalid response (not PDF)';
        }
        echo json_encode(["status" => false, "message" => $error_msg]);
        exit;
    }

    // Confirm it's actually a PDF
    if (substr($pdf, 0, 4) !== '%PDF') {
        echo json_encode([
            "status" => false,
            "message" => "Invalid PDF format received. Response starts with: " . substr($pdf, 0, 50)
        ]);
        exit;
    }

    // ✅ At this point we have a valid PDF → Deduct ₹30 from ALL IN ONE wallet
    $phone_safe = mysqli_real_escape_string($ahk_conn, $panel_phone);
    mysqli_begin_transaction($ahk_conn);
    try {
        $upd = mysqli_query(
            $ahk_conn,
            "UPDATE users SET balance = balance - $service_charge 
             WHERE phone = '$phone_safe' AND balance >= $service_charge"
        );
        if (!$upd || mysqli_affected_rows($ahk_conn) === 0) {
            throw new Exception("Wallet deduction failed");
        }

        $new_balance = get_panel_balance($ahk_conn, $panel_phone);
        $purpose = mysqli_real_escape_string(
            $ahk_conn,
            "Farmer PDF Download UID: $uid (₹$service_charge)"
        );
        mysqli_query(
            $ahk_conn,
            "INSERT INTO wallethistory (userid,amount,balance,purpose,status,type)
             VALUES ('$phone_safe','$service_charge','$new_balance','$purpose','1','Debit')"
        );

        mysqli_commit($ahk_conn);
    } catch (Exception $e) {
        @mysqli_rollback($ahk_conn);
        echo json_encode(["status" => false, "message" => "Wallet deduction failed"]);
        exit;
    }

    // ✅ Output PDF directly (iframe download)
    ob_clean();
    header("Content-Type: application/pdf");
    header("Content-Disposition: attachment; filename=\"farmer_$uid.pdf\"");
    header("Content-Length: " . strlen($pdf));
    header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
    header("Pragma: no-cache");
    header("Expires: 0");
    echo $pdf;
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Farmer PDF Download (All In One)</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <style>
    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      min-height: 100vh;
      padding: 20px;
    }
    .container-custom {
      max-width: 1100px;
      margin: 0 auto;
    }
    .card-custom {
      background: white;
      border-radius: 18px;
      box-shadow: 0 16px 40px rgba(0,0,0,0.25);
      overflow: hidden;
      border: 1px solid rgba(255,255,255,0.2);
    }
    .card-header-custom {
      background: linear-gradient(135deg, #0a7d00 0%, #066000 100%);
      color: white;
      padding: 20px 24px;
      text-align: center;
    }
    .card-header-custom h3 {
      margin: 0;
      font-weight: 600;
    }
    .card-body-custom {
      padding: 26px 26px 24px;
    }
    .balance-box {
      background: linear-gradient(135deg, #10b981 0%, #059669 100%);
      color: white;
      padding: 14px;
      border-radius: 12px;
      margin-bottom: 18px;
      text-align: center;
    }
    .balance-box h4 {
      margin: 0 0 4px 0;
      font-size: 14px;
      opacity: 0.9;
    }
    .balance-box h3 {
      margin: 0;
      font-size: 26px;
      font-weight: 700;
    }
    .info-box {
      background: #f1f5ff;
      border: 1px solid #c7d2fe;
      padding: 14px;
      border-radius: 10px;
      margin-bottom: 18px;
      font-size: 0.9rem;
    }
    .two-column-layout {
      display: grid;
      grid-template-columns: 1.1fr 1fr;
      gap: 18px;
      margin-top: 16px;
    }
    @media (max-width: 768px) {
      .two-column-layout {
        grid-template-columns: 1fr;
      }
    }
    .form-control, .form-select {
      border-radius: 10px;
      padding: 11px 14px;
      border: 2px solid #e5e7eb;
      font-size: 15px;
    }
    .form-control:focus, .form-select:focus {
      border-color: #0a7d00;
      box-shadow: 0 0 0 0.18rem rgba(10,125,0,0.25);
    }
    .btn-primary {
      background: linear-gradient(135deg, #0a7d00 0%, #066000 100%);
      border: none;
      padding: 12px 24px;
      border-radius: 10px;
      font-weight: 600;
      font-size: 16px;
      width: 100%;
      transition: all 0.3s;
    }
    .btn-primary:hover {
      transform: translateY(-2px);
      box-shadow: 0 6px 15px rgba(10,125,0,0.4);
    }
    .notice-board {
      background: #ffffff;
      border-radius: 14px;
      padding: 18px 18px 14px;
      box-shadow: 0 4px 14px rgba(0,0,0,0.06);
      border: 1px solid #e5e7eb;
      height: 100%;
    }
    .notice-board h4 {
      font-size: 18px;
      margin-bottom: 14px;
      color: #1f2937;
    }
    .notice-item {
      padding: 10px 10px;
      background: #f9fafb;
      border-radius: 8px;
      margin-bottom: 8px;
      font-size: 13px;
    }
  </style>
</head>
<body>
  <div class="container-custom">
    <div class="card-custom">
      <div class="card-header-custom">
        <h3><i class="fas fa-file-pdf me-2"></i> Farmer PDF Download (All In One)</h3>
        <div style="font-size:13px;opacity:0.9;">UID + State से Farmer PDF प्राप्त करें (₹30 वॉलेट से केवल सफल डाउनलोड पर)</div>
      </div>
      <div class="card-body-custom">
        <div class="balance-box">
          <h4>Your Wallet Balance / आपका वॉलेट शेष</h4>
          <h3>₹<?php echo number_format($wallet_balance, 2); ?></h3>
        </div>

        <div class="info-box">
          💰 <b>Service Charge / सेवा शुल्क:</b> ₹<?php echo $service_charge; ?><br>
          💸 <b>After Download / डाउनलोड के बाद अनुमानित शेष:</b> ₹<?php echo number_format(max($balance_after, 0), 2); ?><br>
          ⚠️ <b>Note:</b> ₹<?php echo $service_charge; ?> केवल तभी कटेगा जब PDF सफलतापूर्वक generate हो जाएगी।
        </div>

        <div class="two-column-layout">
          <!-- Left: Form -->
          <div>
            <form method="post" id="pdfDownloadForm" onsubmit="return handleDownload(event)">
              <div class="mb-3">
                <label for="uid" class="form-label">
                  <i class="fas fa-fingerprint me-1"></i> UID (Aadhaar) / आधार UID
                </label>
                <input type="text"
                       class="form-control"
                       id="uid"
                       name="uid"
                       placeholder="Enter 12-digit Aadhaar number"
                       maxlength="12"
                       required>
              </div>

              <div class="mb-3">
                <label for="state" class="form-label">
                  <i class="fas fa-map-marker-alt me-1"></i> State / राज्य
                </label>
                <select name="state" class="form-select" id="state" required>
                  <option value="">Select State / राज्य चुनें</option>
                  <?php
                    $states = [
                      'ap' => 'Andhra Pradesh / आंध्र प्रदेश',
                      'as' => 'Assam / असम',
                      'bh' => 'Bihar / बिहार',
                      'cg' => 'Chhattisgarh / छत्तीसगढ़',
                      'gj' => 'Gujarat / गुजरात',
                      'hr' => 'Haryana / हरियाणा',
                      'kl' => 'Kerala / केरल',
                      'mh' => 'Maharashtra / महाराष्ट्र',
                      'mp' => 'Madhya Pradesh / मध्य प्रदेश',
                      'od' => 'Odisha / ओडिशा',
                      'pb' => 'Punjab / पंजाब',
                      'rj' => 'Rajasthan / राजस्थान',
                      'tn' => 'Telangana / तेलंगाना',
                      'up' => 'Uttar Pradesh / उत्तर प्रदेश'
                    ];
                    foreach($states as $code => $name) {
                      echo "<option value=\"$code\">$name</option>";
                    }
                  ?>
                </select>
              </div>

              <div class="alert alert-warning py-2 px-3" style="font-size:13px;">
                ⏱️ <strong>Note:</strong> Download button पर click करने के बाद कुछ सेकंड wait करें, PDF auto download हो जाएगी।
              </div>

              <button type="submit" name="download_pdf" id="downloadBtn" class="btn btn-primary">
                <i class="fas fa-download me-1"></i> Download PDF / PDF डाउनलोड करें
              </button>
            </form>
          </div>

          <!-- Right: Notice -->
          <div class="notice-board">
            <h4><i class="fas fa-bullhorn me-1"></i> Instructions / निर्देश</h4>
            <div class="notice-item">
              <b>1.</b> UID में 12 अंकों की आधार संख्या दर्ज करें (केवल अंक).
            </div>
            <div class="notice-item">
              <b>2.</b> सही राज्य का चयन करें, गलत state पर PDF नहीं मिलेगी।
            </div>
            <div class="notice-item">
              <b>3.</b> Wallet से ₹30 केवल सफल PDF मिलने पर ही कटेगा, किसी भी error पर amount वापस नहीं कटेगा।
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <iframe name="downloadFrame" style="display:none;"></iframe>

  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    function handleDownload(e) {
      e.preventDefault();

      var uid = $('#uid').val().trim();
      var state = $('#state').val().trim();

      if (!uid || uid.length !== 12 || !/^[0-9]{12}$/.test(uid)) {
        Swal.fire({
          icon: 'error',
          title: 'Invalid UID',
          text: 'Please enter a valid 12-digit Aadhaar number'
        });
        return false;
      }

      if (!state) {
        Swal.fire({
          icon: 'error',
          title: 'State Required',
          text: 'Please select a state'
        });
        return false;
      }

      // Disable button
      $('#downloadBtn').prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Processing...');

      // Show processing alert
      Swal.fire({
        title: 'Processing...',
        text: '₹<?php echo $service_charge; ?> wallet se cut hoga, PDF download ho rahi hai',
        icon: 'info',
        showConfirmButton: false,
        allowOutsideClick: false,
        didOpen: () => {
          Swal.showLoading();
        }
      });

      // Create hidden form + iframe submit
      var iframe = document.createElement('iframe');
      iframe.name = 'downloadFrame';
      iframe.style.display = 'none';
      document.body.appendChild(iframe);

      var form = document.createElement('form');
      form.method = 'POST';
      form.action = '';
      form.target = 'downloadFrame';
      form.style.display = 'none';

      var uidInput = document.createElement('input');
      uidInput.type = 'hidden';
      uidInput.name = 'uid';
      uidInput.value = uid;
      form.appendChild(uidInput);

      var stateInput = document.createElement('input');
      stateInput.type = 'hidden';
      stateInput.name = 'state';
      stateInput.value = state;
      form.appendChild(stateInput);

      var submitInput = document.createElement('input');
      submitInput.type = 'hidden';
      submitInput.name = 'download_pdf';
      submitInput.value = '1';
      form.appendChild(submitInput);

      document.body.appendChild(form);
      form.submit();

      // Simple timeout-based success message (PDF will open in browser/downloads)
      setTimeout(function () {
        Swal.close();
        Swal.fire({
          title: 'Success 🎉',
          text: 'If details were correct, PDF download should have started. Please check your downloads folder.',
          icon: 'success',
          confirmButtonText: 'OK'
        });
        $('#downloadBtn').prop('disabled', false).html('<i class="fas fa-download me-1"></i> Download PDF / PDF डाउनलोड करें');
        setTimeout(function () {
          if (document.body.contains(iframe)) document.body.removeChild(iframe);
          if (document.body.contains(form)) document.body.removeChild(form);
        }, 1000);
      }, 6000);

      return false;
    }

    // UID input numeric only
    $('#uid').on('input', function() {
      this.value = this.value.replace(/[^0-9]/g, '').substring(0, 12);
    });
  </script>
</body>
</html>

