<?php
session_start();

require_once __DIR__ . '/../../includes/config.php';

// Get user data from session
$udata = null;
$session_value = null;

if (isset($_SESSION['username']) && !empty($_SESSION['username'])) {
    $session_value = $_SESSION['username'];
} elseif (isset($_SESSION['phone']) && !empty($_SESSION['phone'])) {
    $session_value = $_SESSION['phone'];
} elseif (isset($_SESSION['user_phone']) && !empty($_SESSION['user_phone'])) {
    $session_value = $_SESSION['user_phone'];
} elseif (isset($_SESSION['mobile']) && !empty($_SESSION['mobile'])) {
    $session_value = $_SESSION['mobile'];
}

if ($session_value) {
    $session_escaped = mysqli_real_escape_string($ahk_conn, $session_value);
    $user_query = mysqli_query($ahk_conn, "SELECT * FROM users WHERE phone='$session_escaped' LIMIT 1");
    if ($user_query && mysqli_num_rows($user_query) > 0) {
        $udata = mysqli_fetch_assoc($user_query);
    } else {
        $user_query = mysqli_query($ahk_conn, "SELECT * FROM users WHERE username='$session_escaped' LIMIT 1");
        if ($user_query && mysqli_num_rows($user_query) > 0) {
            $udata = mysqli_fetch_assoc($user_query);
        }
    }
}

if (!$udata) {
    header('Location: ../login.php');
    exit;
}

$current_balance = isset($udata['balance']) ? (float)$udata['balance'] : 0;


// ✅ helper: base64 clean + repair
function clean_base64_pdf($b64) {
    $b64 = trim($b64);

    // remove data prefix if any
    $b64 = preg_replace('#^data:application/pdf;base64,#i', '', $b64);

    // remove all spaces / new lines / invalid chars
    $b64 = preg_replace('/[^A-Za-z0-9\+\/\=\-_]/', '', $b64);

    // convert url-safe base64 to normal base64
    $b64 = str_replace(['-', '_'], ['+', '/'], $b64);

    // fix padding
    $pad = strlen($b64) % 4;
    if ($pad > 0) {
        $b64 .= str_repeat('=', 4 - $pad);
    }

    return $b64;
}


// ✅ POST Download Handler (Direct PDF)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['download'])) {

    // Output buffer clean
    while (ob_get_level()) {
        ob_end_clean();
    }

    $applNum = isset($_POST['applNum']) ? trim($_POST['applNum']) : '';
    if ($applNum === '') {
        header("Content-Type: application/json");
        echo json_encode(['success' => false, 'message' => 'Please enter Application Number']);
        exit;
    }

    $panel_phone = $udata['phone'] ?? '';
    $service_fee = 30;

    // Step 1: Wallet check
    $phone_safe = mysqli_real_escape_string($ahk_conn, $panel_phone);
    $balance_query = mysqli_query($ahk_conn, "SELECT balance FROM users WHERE phone='$phone_safe' LIMIT 1");
    if (!$balance_query || mysqli_num_rows($balance_query) == 0) {
        header("Content-Type: application/json");
        echo json_encode(['success' => false, 'message' => 'Could not fetch wallet balance']);
        exit;
    }

    $wallet_balance = (float)mysqli_fetch_assoc($balance_query)['balance'];
    if ($wallet_balance < $service_fee) {
        header("Content-Type: application/json");
        echo json_encode(['success' => false, 'message' => "Insufficient Balance. Required ₹$service_fee | Balance ₹" . number_format($wallet_balance, 2)]);
        exit;
    }

    // Step 2: Call API
    $api_key = "mk_67efdc429e8f589815fcce6bc14b7eb7";
    $api_url = "https://lostdata.co.in/api/learning-license-pdf.php?api_key=" . urlencode($api_key) . "&applNum=" . urlencode($applNum);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 60);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');
    $api_response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curl_error = curl_error($ch);
    curl_close($ch);

    if ($curl_error) {
        header("Content-Type: application/json");
        echo json_encode(['success' => false, 'message' => 'Connection Error: ' . $curl_error]);
        exit;
    }

    if ($http_code != 200 || empty($api_response)) {
        header("Content-Type: application/json");
        echo json_encode(['success' => false, 'message' => "API Error HTTP($http_code). Response: " . substr($api_response, 0, 200)]);
        exit;
    }

    $json_response = json_decode($api_response, true);
    if (!$json_response || !isset($json_response['status'])) {
        header("Content-Type: application/json");
        echo json_encode(['success' => false, 'message' => 'Invalid API JSON response']);
        exit;
    }

    if ($json_response['status'] !== 'success' || empty($json_response['data']['pdf'])) {
        header("Content-Type: application/json");
        echo json_encode(['success' => false, 'message' => $json_response['message'] ?? 'API failed']);
        exit;
    }

    // Step 3: base64 clean + decode
    $pdf_base64 = clean_base64_pdf($json_response['data']['pdf']);
    $pdf_content = base64_decode($pdf_base64, true);

    if ($pdf_content === false || strlen($pdf_content) < 1000) {
        header("Content-Type: application/json");
        echo json_encode(['success' => false, 'message' => 'PDF decode failed / PDF corrupted']);
        exit;
    }

    if (substr($pdf_content, 0, 4) !== '%PDF') {
        header("Content-Type: application/json");
        echo json_encode(['success' => false, 'message' => 'Invalid PDF header. Corrupt file received']);
        exit;
    }

    // Step 4: Deduct wallet AFTER PDF success
    mysqli_begin_transaction($ahk_conn);

    $update_query = mysqli_query($ahk_conn, "UPDATE users SET balance = balance - $service_fee WHERE phone='$phone_safe'");
    if (!$update_query) {
        mysqli_rollback($ahk_conn);
        header("Content-Type: application/json");
        echo json_encode(['success' => false, 'message' => 'Failed to update wallet']);
        exit;
    }

    $new_balance_query = mysqli_query($ahk_conn, "SELECT balance FROM users WHERE phone='$phone_safe' LIMIT 1");
    $new_balance = (float)mysqli_fetch_assoc($new_balance_query)['balance'];

    $purpose = "Learning License PDF Download - Application No: $applNum (₹$service_fee)";
    $purpose_safe = mysqli_real_escape_string($ahk_conn, $purpose);

    $history_query = mysqli_query(
        $ahk_conn,
        "INSERT INTO wallethistory (userid, amount, balance, purpose, status, type, date)
         VALUES ('$phone_safe', '$service_fee', '$new_balance', '$purpose_safe', '1', 'Debit', NOW())"
    );

    if (!$history_query) {
        mysqli_rollback($ahk_conn);
        header("Content-Type: application/json");
        echo json_encode(['success' => false, 'message' => 'Failed to add wallet history']);
        exit;
    }

    mysqli_commit($ahk_conn);

    // ✅ IMPORTANT FIX:
    // JSON me base64 bhejne ke bajay, server se direct PDF output
    header("Content-Type: application/pdf");
    header("Content-Disposition: attachment; filename=learning_license_$applNum.pdf");
    header("Content-Length: " . strlen($pdf_content));
    header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
    header("Pragma: no-cache");

    echo $pdf_content;
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <style>
        body { font-family: Arial, sans-serif; background: #f5f5f5; padding: 20px; }
        .card { background: white; border-radius: 10px; padding: 25px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); max-width: 500px; margin: 0 auto; }
        .wallet { background: linear-gradient(135deg, #4CAF50, #2E7D32); color: white; padding: 15px; border-radius: 8px; margin-bottom: 20px; }
        .btn-download { background: linear-gradient(135deg, #2196F3, #0D47A1); color: white; border: none; padding: 12px; border-radius: 8px; width: 100%; }
        .loading { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.7); color: white; display: none; flex-direction: column; justify-content: center; align-items: center; z-index: 9999; }
        .spinner { border: 5px solid rgba(255,255,255,0.3); border-radius: 50%; border-top-color: white; width: 50px; height: 50px; animation: spin 1s linear infinite; margin-bottom: 20px; }
        @keyframes spin { 100% { transform: rotate(360deg); } }
        .service-fee { background: linear-gradient(135deg, #FF9800, #E65100); color: white; padding: 5px 15px; border-radius: 20px; font-weight: bold; display: inline-block; margin-bottom: 15px; }
        .test-mode { background: #ffebee; border: 2px dashed #f44336; padding: 10px; border-radius: 8px; margin-bottom: 15px; text-align: center; }
    </style>
</head>
<body>

<div class="loading" id="loading">
    <div class="spinner"></div>
    <h4>Processing...</h4>
    <p>Please wait while we download your PDF</p>
</div>

<div class="card">
    <div class="test-mode">
        <i class="fas fa-vial"></i> <strong>Test Mode:</strong> Use Application Number: <code>434471726</code>
    </div>

    <div style="text-align: center; margin-bottom: 25px;">
        <div style="width: 70px; height: 70px; background: linear-gradient(135deg, #2196F3, #0D47A1); border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 15px;">
            <i class="fas fa-file-pdf" style="font-size: 30px; color: white;"></i>
        </div>
        <h3 style="color: #333; margin-bottom: 5px;">Learning License PDF Download</h3>
        <p style="color: #666; margin-bottom: 10px;">Download learning license PDF using Application Number</p>
        <span class="service-fee">₹30 Only</span>
    </div>

    <div class="wallet">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <span><i class="fas fa-wallet"></i> Wallet Balance</span>
            <span style="font-size: 20px; font-weight: bold;" id="walletBalance">
                ₹<?php echo number_format($current_balance, 2); ?>
            </span>
        </div>
    </div>

    <form id="downloadForm">
        <div style="margin-bottom: 20px;">
            <label style="display: block; margin-bottom: 8px; font-weight: bold; color: #333;">
                <i class="fas fa-id-card"></i> Application Number
            </label>
            <input type="text" id="applNum" name="applNum"
                   style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px;"
                   placeholder="434471726" required>
            <small class="text-muted">Enter application number (e.g., 434471726)</small>
            <div style="color: red; font-size: 14px; margin-top: 5px; display: none;" id="errorMsg"></div>
        </div>

        <button type="submit" class="btn-download" id="downloadBtn">
            <i class="fas fa-download"></i> Download PDF (₹30)
        </button>
    </form>

    <div style="background: #f8f9fa; border-left: 4px solid #2196F3; padding: 15px; border-radius: 8px; margin-top: 20px;">
        <p style="margin: 0; color: #555; font-size: 14px;">
            <i class="fas fa-info-circle" style="color: #2196F3;"></i>
            <strong>Note:</strong> Enter your Learning License Application number. PDF will download automatically after ₹30 deduction.
        </p>
    </div>
</div>

<script>
$(document).ready(function() {
    $('#applNum').val('434471726');

    $('#downloadForm').on('submit', function(e) {
        e.preventDefault();

        let applNum = $('#applNum').val().trim();
        if (!applNum) {
            $('#errorMsg').text('Please enter Application Number').show();
            return;
        }

        $('#loading').css('display', 'flex');
        $('#downloadBtn').prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Processing...');

        // ✅ direct download using POST form submit (not base64 json)
        const form = document.createElement('form');
        form.method = "POST";
        form.action = window.location.href;

        const inp1 = document.createElement('input');
        inp1.type = "hidden";
        inp1.name = "download";
        inp1.value = "1";

        const inp2 = document.createElement('input');
        inp2.type = "hidden";
        inp2.name = "applNum";
        inp2.value = applNum;

        form.appendChild(inp1);
        form.appendChild(inp2);
        document.body.appendChild(form);

        // ✅ download start
        form.submit();

        // UI reset after 3 sec
        setTimeout(function(){
            $('#loading').hide();
            $('#downloadBtn').prop('disabled', false).html('<i class="fas fa-download"></i> Download PDF (₹30)');
            Swal.fire({
                icon: 'success',
                title: 'Processing Done',
                text: 'PDF downloading started. Wallet deducted after success.',
                timer: 4000,
                showConfirmButton: true
            });
        }, 3000);

        document.body.removeChild(form);
    });
});
</script>

</body>
</html>
