<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PAN Applications - Lost Data Solutions</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
</head>
<body>

<?php
include('../header.php');

$username = $udata['phone'];

// Get API key for main website
$api_key = "enter api key"; // Admin API Key
$api_url = "https://lostdata.co.in/api/pan-status.php";

// Fetch applications from API (Main Website Database)
$url = $api_url . "?api_key=" . urlencode($api_key);

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_SSL_VERIFYPEER => false
]);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curl_error = curl_error($ch);
curl_close($ch);

$applications_data = [];
$stats = ['total' => 0, 'pending' => 0, 'approved' => 0, 'rejected' => 0];
$api_error = '';
$debug_info = '';

if ($curl_error) {
    $api_error = "cURL Error: $curl_error";
    $debug_info = "URL: $url | cURL Error: $curl_error";
} elseif ($http_code == 200 && !empty($response)) {
    $result = json_decode($response, true);
    if (isset($result['success']) && $result['success'] === true) {
        $all_apps = $result['data'] ?? [];
        
        // Filter applications (API should filter by API user automatically)
        $applications_data = $all_apps;
        
        // Calculate stats
        foreach ($applications_data as $app) {
            $stats['total']++;
            $status = strtolower($app['status'] ?? 'pending');
            if ($status === 'pending') {
                $stats['pending']++;
            } elseif (in_array($status, ['approved', 'completed'])) {
                $stats['approved']++;
            } elseif ($status === 'rejected') {
                $stats['rejected']++;
            }
        }
        
        $debug_info = "Success: Found " . count($applications_data) . " applications";
    } else {
        $api_error = $result['error'] ?? $result['message'] ?? 'Unknown API error';
        $debug_info = "API Response: " . substr($response, 0, 200);
    }
} else {
    $api_error = "API Error: HTTP Code $http_code";
    if (!empty($response)) {
        $error_result = json_decode($response, true);
        $api_error .= ' - ' . ($error_result['error'] ?? $error_result['message'] ?? 'No response');
        $debug_info = "Response: " . substr($response, 0, 500);
    } else {
        $debug_info = "No response from API";
    }
}
?>

<div class="page-wrapper">
<div class="page-content">
<div class="card">
<div class="card-body">

<div class="d-flex justify-content-between align-items-center mb-3">
    <h4><i class="fas fa-history me-2"></i>PAN Applications</h4>
    <a href="pan-apply.php" class="btn btn-primary">
        <i class="fas fa-plus me-1"></i>New Application
    </a>
</div>

<!-- Statistics -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body text-center">
                <h3><?php echo $stats['total']; ?></h3>
                <p class="mb-0">Total Applications</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-warning text-dark">
            <div class="card-body text-center">
                <h3><?php echo $stats['pending']; ?></h3>
                <p class="mb-0">Pending</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body text-center">
                <h3><?php echo $stats['approved']; ?></h3>
                <p class="mb-0">Approved</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-danger text-white">
            <div class="card-body text-center">
                <h3><?php echo $stats['rejected']; ?></h3>
                <p class="mb-0">Rejected</p>
            </div>
        </div>
    </div>
</div>

<?php if($api_error): ?>
    <div class="alert alert-danger">
        <i class="fas fa-exclamation-triangle me-2"></i>
        <strong>API Error:</strong> <?php echo htmlspecialchars($api_error); ?>
        <?php if($debug_info): ?>
            <br><small>Debug: <?php echo htmlspecialchars($debug_info); ?></small>
        <?php endif; ?>
    </div>
<?php endif; ?>

<?php if(count($applications_data) == 0 && !$api_error): ?>
    <div class="alert alert-info">
        <i class="fas fa-info-circle me-2"></i>
        No applications found.
        <br><small>If you just applied, please wait a moment and refresh the page.</small>
    </div>
<?php endif; ?>

<?php if(count($applications_data) > 0): ?>
    <div class="table-responsive">
        <table class="table table-hover table-striped" id="applicationsTable">
            <thead class="table-dark">
                <tr>
                    <th>ID</th>
                    <th>Application No</th>
                    <th>Name</th>
                    <th>Phone</th>
                    <th>Fee</th>
                    <th>Status</th>
                    <th>Certificate</th>
                    <th>Applied Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($applications_data as $app): 
                    $app_id = $app['id'] ?? 0;
                    $app_no = $app['application_no'] ?? 'PAN' . $app_id;
                    $name = htmlspecialchars($app['name'] ?? 'N/A');
                    $phone = htmlspecialchars($app['phone'] ?? 'N/A');
                    $fee = 150; // All in one wallet fee (₹150), not API fee
                    $status = strtolower($app['status'] ?? 'pending');
                    $created_at = $app['created_at'] ?? '';
                    $certificate_url = $app['certificate_url'] ?? '';
                    
                    // Status badge
                    $status_class = 'warning';
                    $status_text = ucfirst($status);
                    if ($status === 'approved' || $status === 'completed') {
                        $status_class = 'success';
                    } elseif ($status === 'rejected') {
                        $status_class = 'danger';
                    }
                ?>
                <tr>
                    <td>#<?php echo $app_id; ?></td>
                    <td><strong><?php echo $app_no; ?></strong></td>
                    <td><?php echo $name; ?></td>
                    <td><?php echo $phone; ?></td>
                    <td>₹<?php echo number_format($fee, 2); ?></td>
                    <td>
                        <span class="badge bg-<?php echo $status_class; ?>">
                            <?php echo $status_text; ?>
                        </span>
                    </td>
                    <td>
                        <?php if (!empty($certificate_url)): ?>
                            <a href="<?php echo htmlspecialchars($certificate_url); ?>" target="_blank" class="btn btn-sm btn-success">
                                <i class="fas fa-download"></i> Download
                            </a>
                        <?php else: ?>
                            <span class="text-muted">-</span>
                        <?php endif; ?>
                    </td>
                    <td><?php echo $created_at ? date('d M Y, h:i A', strtotime($created_at)) : 'N/A'; ?></td>
                    <td>
                        <button class="btn btn-sm btn-info" onclick="viewDetails(<?php echo $app_id; ?>)">
                            <i class="fas fa-eye"></i> View Details
                        </button>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
<?php endif; ?>

</div>
</div>
</div>
</div>

<!-- View Details Modal -->
<div class="modal fade" id="detailsModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="fas fa-id-card me-2"></i>Application Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="modalBody">
                <div class="text-center">
                    <div class="spinner-border" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>

<script>
$(document).ready(function() {
    $('#applicationsTable').DataTable({
        order: [[0, 'desc']],
        pageLength: 10,
        language: {
            search: "Search:",
            lengthMenu: "Show _MENU_ entries",
            info: "Showing _START_ to _END_ of _TOTAL_ entries",
            paginate: {
                first: "First",
                last: "Last",
                next: "Next",
                previous: "Previous"
            }
        }
    });
});

function viewDetails(appId) {
    $('#detailsModal').modal('show');
    $('#modalBody').html('<div class="text-center"><div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div></div>');
    
    // Fetch application details from API
    var apiUrl = 'https://lostdata.co.in/api/pan-status.php?api_key=<?php echo urlencode($api_key); ?>&app_id=' + appId;
    
    $.ajax({
        url: apiUrl,
        method: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.success && response.application) {
                var app = response.application;
                
                var html = '<div class="mb-3">';
                html += '<p><strong>Application ID:</strong> #' + app.id + '</p>';
                html += '<p><strong>Application No:</strong> ' + (app.application_no || 'PAN' + app.id) + '</p>';
                html += '<p><strong>Name:</strong> ' + (app.name || 'N/A') + '</p>';
                html += '<p><strong>Father\'s Name:</strong> ' + (app.father_name || 'N/A') + '</p>';
                html += '<p><strong>DOB:</strong> ' + (app.dob || 'N/A') + '</p>';
                html += '<p><strong>Gender:</strong> ' + (app.gender || 'N/A') + '</p>';
                html += '<p><strong>Phone:</strong> ' + (app.phone || 'N/A') + '</p>';
                html += '<p><strong>Email:</strong> ' + (app.email || 'N/A') + '</p>';
                html += '<p><strong>Address:</strong> ' + (app.village || '') + ', ' + (app.post || '') + ', ' + (app.pincode || '') + '</p>';
                html += '<p><strong>District:</strong> ' + (app.district || 'N/A') + '</p>';
                html += '<p><strong>State:</strong> ' + (app.state || 'N/A') + '</p>';
                html += '<p><strong>Fee:</strong> ₹150.00</p>'; // All in one wallet fee
                html += '<p><strong>Status:</strong> <span class="badge bg-' + (app.status === 'approved' ? 'success' : 'warning') + '">' + (app.status || 'pending') + '</span></p>';
                if (app.ack_number) {
                    html += '<p><strong>Acknowledgment Number:</strong> ' + app.ack_number + '</p>';
                }
                if (app.rejection_reason) {
                    html += '<p><strong>Rejection Reason:</strong> <span class="text-danger">' + app.rejection_reason + '</span></p>';
                }
                if (app.certificate_url) {
                    html += '<p><strong>Certificate:</strong> <a href="' + app.certificate_url + '" target="_blank" class="btn btn-sm btn-primary"><i class="fas fa-download"></i> Download</a></p>';
                }
                html += '<p><strong>Applied Date:</strong> ' + (app.created_at || 'N/A') + '</p>';
                html += '</div>';
                
                $('#modalBody').html(html);
            } else {
                $('#modalBody').html('<div class="alert alert-danger">Failed to load application details: ' + (response.message || 'Unknown error') + '</div>');
            }
        },
        error: function(xhr, status, error) {
            $('#modalBody').html('<div class="alert alert-danger">Error loading application details: ' + error + '</div>');
        }
    });
}
</script>

</body>
</html>
