<?php
// Start session
session_start();

require_once __DIR__ . '/../../includes/config.php';

// Get user data from session
$udata = null;
$session_value = null;

if (isset($_SESSION['username']) && !empty($_SESSION['username'])) {
    $session_value = $_SESSION['username'];
} elseif (isset($_SESSION['phone']) && !empty($_SESSION['phone'])) {
    $session_value = $_SESSION['phone'];
} elseif (isset($_SESSION['user_phone']) && !empty($_SESSION['user_phone'])) {
    $session_value = $_SESSION['user_phone'];
} elseif (isset($_SESSION['mobile']) && !empty($_SESSION['mobile'])) {
    $session_value = $_SESSION['mobile'];
}

if ($session_value) {
    $session_escaped = mysqli_real_escape_string($ahk_conn, $session_value);
    // Try by phone field first
    $user_query = mysqli_query($ahk_conn, "SELECT * FROM users WHERE phone='$session_escaped' LIMIT 1");
    if ($user_query && mysqli_num_rows($user_query) > 0) {
        $udata = mysqli_fetch_assoc($user_query);
    } else {
        // Try by username field
        $user_query = mysqli_query($ahk_conn, "SELECT * FROM users WHERE username='$session_escaped' LIMIT 1");
        if ($user_query && mysqli_num_rows($user_query) > 0) {
            $udata = mysqli_fetch_assoc($user_query);
        }
    }
}

if (!$udata) {
    // Redirect to login if user not found
    header('Location: ../login.php');
    exit;
}

$result_data = null;
$ration_number = '';

if (isset($_POST['ration_number'])) {
    $ration_number = trim($_POST['ration_number']);
    
    // Remove spaces
    $ration_number = preg_replace('/\s+/', '', $ration_number);

    if (empty($ration_number)) {
        echo "<script>
            Swal.fire(
                'Invalid Ration Number',
                'Please enter valid Ration Number',
                'error'
            );
        </script>";
    } else {
        // Service fee
        $fee = 70; // ₹70
        $username = $udata['phone'];
        $wallet_amount = $udata['balance'];

        if ($wallet_amount >= $fee) {
            $debit_fee = $wallet_amount - $fee;
            
            // API CALL to Ration UID Search2 API
            $api_key = "enter api key"; // Admin API Key
            $url = "https://lostdata.co.in/api/ration-uid-search2.php?api_key=" . urlencode($api_key) . "&rationNumber=" . urlencode($ration_number);

            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 60,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_USERAGENT => 'Mozilla/5.0'
            ));

            $response = curl_exec($curl);
            $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            $curl_error = curl_error($curl);
            curl_close($curl);
            
            // Check for curl errors
            if ($curl_error) {
                echo "<script>
                    Swal.fire(
                        'Connection Error',
                        '" . addslashes($curl_error) . "',
                        'error'
                    );
                </script>";
            } elseif ($http_code != 200) {
                echo "<script>
                    Swal.fire(
                        'API Error',
                        'HTTP Error: $http_code',
                        'error'
                    );
                </script>";
            } else {
                // Parse JSON response
                $resdata = json_decode($response, true);
                
                if ($resdata && isset($resdata['success']) && $resdata['success'] === true && 
                    isset($resdata['data']['Status']) && $resdata['data']['Status'] === 'Success') {
                    $result_data = $resdata;
                    
                    // Deduct wallet and save
                    $debit = mysqli_query($ahk_conn, "UPDATE users SET balance='$debit_fee' WHERE phone='$username'");
                    if ($debit) {
                        // Add wallet history
                        $purpose = mysqli_real_escape_string($ahk_conn, "Ration to Aadhar UID Search - Ration No: $ration_number (₹$fee)");
                        $history_query = mysqli_query($ahk_conn, "INSERT INTO wallethistory (userid, amount, balance, purpose, status, type, date) VALUES ('$username', '$fee', '$debit_fee', '$purpose', '1', 'Debit', NOW())");
                        
                        // Save to history table
                        $members_count = isset($resdata['data']['total_members']) ? intval($resdata['data']['total_members']) : 0;
                        $api_response_json = mysqli_real_escape_string($ahk_conn, json_encode($resdata, JSON_UNESCAPED_UNICODE));
                        $insert_history = mysqli_query($ahk_conn, "INSERT INTO ration_to_aadhar_uid_history (username, ration_number, api_response, members_count, service_charge, status, date) VALUES ('$username', '$ration_number', '$api_response_json', '$members_count', '$fee', 'Success', NOW())");
                        
                        echo "<script>
                            Swal.fire(
                                'Success',
                                'Ration to Aadhar UID data retrieved successfully!',
                                'success'
                            );
                        </script>";
                    }
                } else {
                    $error_msg = 'Unknown error';
                    if ($resdata && isset($resdata['message'])) {
                        $error_msg = $resdata['message'];
                    } elseif ($resdata && isset($resdata['error'])) {
                        $error_msg = $resdata['error'];
                    }
                    echo "<script>
                        Swal.fire(
                            '" . addslashes($error_msg) . "',
                            'Ration Number Not Found',
                            'warning'
                        );
                    </script>";
                }
            }
        } else {
            echo "<script>
                Swal.fire(
                    'Oops!',
                    'Wallet Balance Insufficient! Required ₹$fee | Available ₹" . number_format($wallet_amount, 2) . "',
                    'error'
                );
                setTimeout(() => {
                    window.location.href = 'wallet.php';
                }, 2000);
            </script>";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Ration to Aadhar UID Search | FastPrint</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <!-- Custom CSS -->
    <style>
        :root {
            --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            --secondary-gradient: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            --success-gradient: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
            --warning-gradient: linear-gradient(135deg, #f6d365 0%, #fda085 100%);
            --dark-gradient: linear-gradient(135deg, #2b5876 0%, #4e4376 100%);
            --light-bg: #f8fafc;
            --card-shadow: 0 10px 40px rgba(0,0,0,0.08);
            --card-shadow-hover: 0 15px 50px rgba(0,0,0,0.12);
            --border-radius-xl: 20px;
            --border-radius-lg: 15px;
            --border-radius-md: 10px;
            --transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
        }
        
        body {
            background: var(--light-bg);
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            min-height: 100vh;
            color: #333;
        }
        
        /* Header Styling */
        .custom-header {
            background: var(--dark-gradient);
            color: white;
            padding: 1.5rem 0;
            position: relative;
            overflow: hidden;
        }
        
        .custom-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url("data:image/svg+xml,%3Csvg width='100' height='100' viewBox='0 0 100 100' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M11 18c3.866 0 7-3.134 7-7s-3.134-7-7-7-7 3.134-7 7 3.134 7 7 7zm48 25c3.866 0 7-3.134 7-7s-3.134-7-7-7-7 3.134-7 7 3.134 7 7 7zm-43-7c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zm63 31c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zM34 90c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zm56-76c1.657 0 3-1.343 3-3s-1.343-3-3-3-3 1.343-3 3 1.343 3 3 3zM12 86c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm28-65c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm23-11c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm-6 60c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm29 22c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zM32 63c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm57-13c2.76 0 5-2.24 5-5s-2.24-5-5-5-5 2.24-5 5 2.24 5 5 5zm-9-21c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM60 91c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM35 41c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2zM12 60c1.105 0 2-.895 2-2s-.895-2-2-2-2 .895-2 2 .895 2 2 2z' fill='%23ffffff' fill-opacity='0.05' fill-rule='evenodd'/%3E%3C/svg%3E");
        }
        
        /* Enhanced Card Design */
        .premium-card {
            background: white;
            border-radius: var(--border-radius-lg);
            box-shadow: var(--card-shadow);
            border: none;
            overflow: hidden;
            transition: var(--transition);
            margin-bottom: 25px;
            position: relative;
        }
        
        .premium-card:hover {
            transform: translateY(-8px);
            box-shadow: var(--card-shadow-hover);
        }
        
        .card-header-gradient {
            background: var(--primary-gradient);
            color: white;
            padding: 1.5rem;
            border-bottom: none;
        }
        
        .card-header-gradient::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: var(--secondary-gradient);
        }
        
        /* Stats Cards */
        .stat-card {
            background: white;
            padding: 1.5rem;
            border-radius: var(--border-radius-md);
            box-shadow: 0 5px 20px rgba(0,0,0,0.05);
            transition: var(--transition);
            border-left: 4px solid;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        
        .stat-card.balance {
            border-left-color: #4CAF50;
        }
        
        .stat-card.fee {
            border-left-color: #FF9800;
        }
        
        .stat-card.speed {
            border-left-color: #2196F3;
        }
        
        .stat-card.accuracy {
            border-left-color: #9C27B0;
        }
        
        /* Form Elements */
        .form-control-custom {
            border: 2px solid #e9ecef;
            border-radius: var(--border-radius-md);
            padding: 0.875rem 1rem;
            font-size: 1rem;
            transition: var(--transition);
            background: white;
        }
        
        .form-control-custom:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
            transform: translateY(-2px);
        }
        
        /* Buttons */
        .btn-gradient {
            background: var(--primary-gradient);
            color: white;
            border: none;
            padding: 0.875rem 2rem;
            border-radius: var(--border-radius-md);
            font-weight: 600;
            transition: var(--transition);
            position: relative;
            overflow: hidden;
        }
        
        .btn-gradient:hover {
            color: white;
            transform: translateY(-3px);
            box-shadow: 0 10px 25px rgba(102, 126, 234, 0.3);
        }
        
        .btn-gradient::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: var(--secondary-gradient);
            opacity: 0;
            transition: opacity 0.3s;
        }
        
        .btn-gradient:hover::after {
            opacity: 1;
        }
        
        /* Result Display */
        .result-badge {
            padding: 0.5rem 1.5rem;
            border-radius: 50px;
            font-weight: 600;
            background: var(--success-gradient);
            color: white;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }
        
        .member-card {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border-radius: var(--border-radius-md);
            padding: 1rem;
            margin-bottom: 0.75rem;
            border-left: 4px solid #667eea;
            transition: var(--transition);
        }
        
        .member-card:hover {
            transform: translateX(5px);
            background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
        }
        
        /* Table Styling */
        .table-custom {
            background: white;
            border-radius: var(--border-radius-md);
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
        }
        
        .table-custom thead th {
            background: var(--primary-gradient);
            color: white;
            border: none;
            font-weight: 600;
            padding: 1rem;
        }
        
        .table-custom tbody tr {
            transition: var(--transition);
        }
        
        .table-custom tbody tr:hover {
            background-color: rgba(102, 126, 234, 0.05);
        }
        
        /* Loading Animation */
        .loader-container {
            display: none;
            text-align: center;
            padding: 3rem;
        }
        
        .loader {
            width: 60px;
            height: 60px;
            border: 5px solid #f3f3f3;
            border-top: 5px solid #667eea;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin: 0 auto 1rem;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        /* Responsive Adjustments */
        @media (max-width: 768px) {
            .custom-header h1 {
                font-size: 1.5rem;
            }
            
            .premium-card {
                margin-bottom: 15px;
            }
            
            .btn-gradient {
                padding: 0.75rem 1.5rem;
            }
        }
        
        /* Custom Scrollbar */
        ::-webkit-scrollbar {
            width: 8px;
        }
        
        ::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 10px;
        }
        
        ::-webkit-scrollbar-thumb {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 10px;
        }
        
        /* Animation for results */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .fade-in-up {
            animation: fadeInUp 0.6s ease-out;
        }
        
        .text-purple {
            color: #9C27B0 !important;
        }
    </style>
</head>
<body>
    <!-- Premium Header -->
    <header class="custom-header">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <h1 class="mb-2">
                        <i class="fas fa-id-card-alt me-2"></i>Ration to Aadhar UID Search
                    </h1>
                    <p class="mb-0 opacity-90">
                        <i class="fas fa-bolt me-1"></i> Instant search with 100% accuracy
                    </p>
                </div>
                <div class="col-md-6 text-md-end">
                    <div class="d-flex flex-wrap justify-content-md-end gap-2">
                        <div class="stat-card balance me-2 mb-2">
                            <div class="d-flex align-items-center">
                                <div class="bg-success bg-opacity-10 p-2 rounded-circle me-3">
                                    <i class="fas fa-wallet text-success"></i>
                                </div>
                                <div>
                                    <small class="text-muted d-block">Wallet Balance</small>
                                    <h4 class="mb-0 text-success">₹<?php echo number_format($udata['balance'], 2); ?></h4>
                                </div>
                            </div>
                        </div>
                        <a href="../dashboard.php" class="btn btn-outline-light btn-sm align-self-center mb-2">
                            <i class="fas fa-home me-1"></i> Dashboard
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <!-- Main Content -->
    <main class="container py-4">
        <!-- Stats Section -->
        <div class="row g-3 mb-4">
            <div class="col-lg-3 col-md-6">
                <div class="stat-card fee">
                    <div class="d-flex align-items-center">
                        <div class="bg-warning bg-opacity-10 p-2 rounded-circle me-3">
                            <i class="fas fa-rupee-sign text-warning"></i>
                        </div>
                        <div>
                            <small class="text-muted d-block">Service Fee</small>
                            <h4 class="mb-0 text-warning">₹70</h4>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="stat-card speed">
                    <div class="d-flex align-items-center">
                        <div class="bg-primary bg-opacity-10 p-2 rounded-circle me-3">
                            <i class="fas fa-bolt text-primary"></i>
                        </div>
                        <div>
                            <small class="text-muted d-block">Search Speed</small>
                            <h4 class="mb-0 text-primary">Instant</h4>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="stat-card accuracy">
                    <div class="d-flex align-items-center">
                        <div class="bg-purple bg-opacity-10 p-2 rounded-circle me-3">
                            <i class="fas fa-check-circle text-purple"></i>
                        </div>
                        <div>
                            <small class="text-muted d-block">Accuracy</small>
                            <h4 class="mb-0 text-purple">100%</h4>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <a href="ration-to-aadhar-uid-list.php" class="text-decoration-none">
                    <div class="stat-card" style="border-left-color: #00bcd4; cursor: pointer;">
                        <div class="d-flex align-items-center">
                            <div class="bg-info bg-opacity-10 p-2 rounded-circle me-3">
                                <i class="fas fa-history text-info"></i>
                            </div>
                            <div>
                                <small class="text-muted d-block">Search History</small>
                                <h4 class="mb-0 text-info">View All</h4>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
        </div>

        <!-- Main Content Row -->
        <div class="row">
            <!-- Left Column - Search Form -->
            <div class="col-lg-6 mb-4">
                <div class="premium-card">
                    <div class="card-header-gradient">
                        <h3 class="mb-0">
                            <i class="fas fa-search me-2"></i> Enter Ration Details
                        </h3>
                    </div>
                    <div class="card-body p-4">
                        <!-- Fee Alert -->
                        <div class="alert alert-warning border-warning bg-warning bg-opacity-10 border-start-0 border-end-0 border-3 mb-4">
                            <div class="d-flex align-items-center">
                                <i class="fas fa-info-circle fa-lg me-3 text-warning"></i>
                                <div>
                                    <h6 class="alert-heading mb-1">Service Fee: ₹70</h6>
                                    <p class="mb-0 small">Amount will be deducted from your wallet balance</p>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Search Form -->
                        <form method="POST" id="searchForm">
                            <div class="mb-4">
                                <label class="form-label fw-bold mb-2">
                                    <i class="fas fa-hashtag me-1"></i> Ration Card Number *
                                </label>
                                <input type="text" 
                                       class="form-control form-control-custom" 
                                       name="ration_number" 
                                       placeholder="Enter 12-digit ration number (e.g., 217241324909)"
                                       required
                                       value="<?php echo htmlspecialchars($ration_number); ?>">
                                <div class="form-text mt-2">
                                    <i class="fas fa-lightbulb me-1"></i> Enter complete ration number without spaces
                                </div>
                            </div>
                            
                            <!-- Wallet Check -->
                            <div class="alert <?php echo ($udata['balance'] >= 70) ? 'alert-success' : 'alert-danger'; ?> mb-4">
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-<?php echo ($udata['balance'] >= 70) ? 'check-circle' : 'exclamation-triangle'; ?> me-3"></i>
                                    <div>
                                        <h6 class="alert-heading mb-1">
                                            <?php echo ($udata['balance'] >= 70) ? 'Sufficient Balance' : 'Insufficient Balance'; ?>
                                        </h6>
                                        <p class="mb-0">
                                            Required: ₹70 | Available: ₹<?php echo number_format($udata['balance'], 2); ?>
                                            <?php if($udata['balance'] < 70): ?>
                                                <a href="wallet.php" class="alert-link ms-2">Add Money</a>
                                            <?php endif; ?>
                                        </p>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Action Buttons -->
                            <div class="d-grid gap-2">
                                <button type="submit" 
                                        name="submit" 
                                        class="btn-gradient btn-lg"
                                        <?php echo ($udata['balance'] < 70) ? 'disabled' : ''; ?>>
                                    <i class="fas fa-paper-plane me-2"></i> Search Now
                                </button>
                                <div class="d-flex gap-2">
                                    <a href="wallet.php" class="btn btn-outline-primary flex-fill">
                                        <i class="fas fa-plus-circle me-1"></i> Add Money
                                    </a>
                                    <a href="javascript:history.back()" class="btn btn-outline-secondary flex-fill">
                                        <i class="fas fa-arrow-left me-1"></i> Go Back
                                    </a>
                                </div>
                            </div>
                        </form>
                        
                        <!-- Loading Indicator -->
                        <div class="loader-container" id="loadingIndicator">
                            <div class="loader"></div>
                            <p class="text-muted mt-3">Searching database... Please wait</p>
                        </div>
                    </div>
                </div>
                
                <!-- Quick Guide -->
                <div class="premium-card mt-4">
                    <div class="card-header" style="background: var(--dark-gradient);">
                        <h5 class="mb-0 text-white">
                            <i class="fas fa-info-circle me-2"></i> How to Use
                        </h5>
                    </div>
                    <div class="card-body p-3">
                        <div class="row g-3">
                            <div class="col-6">
                                <div class="text-center p-3 bg-light rounded">
                                    <div class="mb-2">
                                        <span class="badge bg-primary rounded-circle p-2">1</span>
                                    </div>
                                    <h6 class="mb-1">Enter Number</h6>
                                    <p class="small text-muted mb-0">Provide ration card number</p>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="text-center p-3 bg-light rounded">
                                    <div class="mb-2">
                                        <span class="badge bg-success rounded-circle p-2">2</span>
                                    </div>
                                    <h6 class="mb-1">Pay Fee</h6>
                                    <p class="small text-muted mb-0">₹70 from wallet</p>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="text-center p-3 bg-light rounded">
                                    <div class="mb-2">
                                        <span class="badge bg-warning rounded-circle p-2">3</span>
                                    </div>
                                    <h6 class="mb-1">Get Results</h6>
                                    <p class="small text-muted mb-0">Instant Aadhar UIDs</p>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="text-center p-3 bg-light rounded">
                                    <div class="mb-2">
                                        <span class="badge bg-info rounded-circle p-2">4</span>
                                    </div>
                                    <h6 class="mb-1">Save/Print</h6>
                                    <p class="small text-muted mb-0">Download results</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Column - Results -->
            <div class="col-lg-6 mb-4">
                <?php if ($result_data && isset($result_data['data']['Status']) && $result_data['data']['Status'] === 'Success'): ?>
                    <div class="premium-card fade-in-up">
                        <div class="card-header-gradient d-flex justify-content-between align-items-center">
                            <h3 class="mb-0">
                                <i class="fas fa-file-alt me-2"></i> Search Results
                            </h3>
                            <span class="result-badge">
                                <i class="fas fa-check-circle"></i> SUCCESS
                            </span>
                        </div>
                        <div class="card-body p-4">
                            <!-- Summary Cards -->
                            <div class="row g-3 mb-4">
                                <div class="col-md-6">
                                    <div class="bg-light p-3 rounded">
                                        <small class="text-muted d-block">Ration Number</small>
                                        <h4 class="text-primary mb-0">
                                            <?php echo htmlspecialchars($result_data['data']['rationNumber'] ?? $ration_number); ?>
                                        </h4>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="bg-light p-3 rounded">
                                        <small class="text-muted d-block">Total Members</small>
                                        <h4 class="text-success mb-0">
                                            <?php echo htmlspecialchars($result_data['data']['total_members'] ?? 0); ?>
                                            <small class="text-muted fs-6">Persons</small>
                                        </h4>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Aadhar UIDs Section -->
                            <?php if (isset($result_data['data']['uidNumbers']) && is_array($result_data['data']['uidNumbers'])): ?>
                            <div class="mb-4">
                                <h5 class="mb-3 border-bottom pb-2">
                                    <i class="fas fa-fingerprint me-2"></i> Aadhar UID Numbers
                                </h5>
                                <div class="row g-2">
                                    <?php foreach ($result_data['data']['uidNumbers'] as $index => $uid): ?>
                                        <div class="col-md-6">
                                            <div class="member-card">
                                                <div class="d-flex align-items-center">
                                                    <div class="bg-primary bg-opacity-10 p-2 rounded-circle me-3">
                                                        <i class="fas fa-user text-primary"></i>
                                                    </div>
                                                    <div class="flex-grow-1">
                                                        <small class="text-muted d-block">UID <?php echo $index + 1; ?></small>
                                                        <code class="text-primary fw-bold"><?php echo htmlspecialchars($uid); ?></code>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                            <!-- Family Members Table -->
                            <?php if (isset($result_data['data']['members']) && is_array($result_data['data']['members'])): ?>
                            <div>
                                <h5 class="mb-3 border-bottom pb-2">
                                    <i class="fas fa-users me-2"></i> Family Members Details
                                </h5>
                                <div class="table-responsive">
                                    <table class="table table-custom">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Name</th>
                                                <th>Gender</th>
                                                <th>DOB</th>
                                                <th>Aadhar UID</th>
                                                <th>Relation</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($result_data['data']['members'] as $member): ?>
                                                <tr>
                                                    <td>
                                                        <span class="badge bg-secondary rounded-circle"><?php echo $member['srno']; ?></span>
                                                    </td>
                                                    <td class="fw-bold"><?php echo htmlspecialchars($member['Nameof_Family_Member_EN']); ?></td>
                                                    <td>
                                                        <span class="badge bg-<?php echo ($member['Gender'] == 'Male') ? 'primary' : 'danger'; ?>">
                                                            <?php echo $member['Gender']; ?>
                                                        </span>
                                                    </td>
                                                    <td><?php echo $member['DOB']; ?></td>
                                                    <td>
                                                        <code class="text-success"><?php echo $member['UIDNo']; ?></code>
                                                    </td>
                                                    <td>
                                                        <span class="badge bg-info"><?php echo $member['RELATION']; ?></span>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                            <!-- Action Buttons -->
                            <div class="d-flex justify-content-end gap-2 mt-4 pt-3 border-top">
                                <button class="btn btn-outline-success" onclick="exportToPDF()">
                                    <i class="fas fa-file-pdf me-1"></i> Save PDF
                                </button>
                                <button class="btn btn-outline-primary" onclick="printResults()">
                                    <i class="fas fa-print me-1"></i> Print
                                </button>
                                <button class="btn btn-gradient" onclick="copyResults()">
                                    <i class="fas fa-copy me-1"></i> Copy All
                                </button>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <!-- Default State -->
                    <div class="premium-card">
                        <div class="card-header-gradient">
                            <h3 class="mb-0">
                                <i class="fas fa-chart-bar me-2"></i> Results Preview
                            </h3>
                        </div>
                        <div class="card-body p-5 text-center">
                            <div class="mb-4">
                                <div class="bg-light rounded-circle d-inline-flex p-4 mb-3">
                                    <i class="fas fa-search fa-3x text-muted"></i>
                                </div>
                                <h4 class="text-muted mb-3">No Search Performed</h4>
                                <p class="text-muted mb-4">
                                    Enter a ration card number to view associated Aadhar UID numbers and family details here.
                                </p>
                                <div class="text-start bg-light p-4 rounded">
                                    <h6 class="mb-3">
                                        <i class="fas fa-star me-2 text-warning"></i> What You'll Get:
                                    </h6>
                                    <ul class="list-unstyled mb-0">
                                        <li class="mb-2">
                                            <i class="fas fa-check-circle text-success me-2"></i>
                                            All associated Aadhar UID numbers
                                        </li>
                                        <li class="mb-2">
                                            <i class="fas fa-check-circle text-success me-2"></i>
                                            Complete family member details
                                        </li>
                                        <li class="mb-2">
                                            <i class="fas fa-check-circle text-success me-2"></i>
                                            Gender and relationship information
                                        </li>
                                        <li>
                                            <i class="fas fa-check-circle text-success me-2"></i>
                                            Date of birth for each member
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </main>

    <!-- Footer -->
    <footer class="bg-dark text-white py-4 mt-4">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <h5 class="mb-2">
                        <i class="fas fa-shield-alt me-2"></i> FastPrint Services
                    </h5>
                    <p class="mb-0 text-muted">
                        Secure and reliable ration to Aadhar UID search service
                    </p>
                </div>
                <div class="col-md-6 text-md-end">
                    <p class="mb-0">
                        <i class="fas fa-copyright me-1"></i> <?php echo date('Y'); ?> FastPrint. All rights reserved.
                    </p>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap JS Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom JavaScript -->
    <script>
        // Form submission handler
        document.getElementById('searchForm')?.addEventListener('submit', function(e) {
            const rationNumber = this.querySelector('[name="ration_number"]').value.trim();
            if (!rationNumber) {
                e.preventDefault();
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Please enter a ration number',
                    confirmButtonColor: '#667eea'
                });
                return;
            }
            
            // Show loading indicator
            const loader = document.getElementById('loadingIndicator');
            if (loader) loader.style.display = 'block';
        });
        
        // Export functions
        function exportToPDF() {
            Swal.fire({
                icon: 'info',
                title: 'Export PDF',
                text: 'PDF export feature will be available soon!',
                confirmButtonColor: '#667eea'
            });
        }
        
        function printResults() {
            window.print();
        }
        
        function copyResults() {
            const rationNo = document.querySelector('.text-primary')?.innerText;
            const members = document.querySelectorAll('.member-card code');
            let textToCopy = `Ration Number: ${rationNo}\n\nAadhar UID Numbers:\n`;
            
            members.forEach((member, index) => {
                textToCopy += `${index + 1}. ${member.innerText}\n`;
            });
            
            navigator.clipboard.writeText(textToCopy).then(() => {
                Swal.fire({
                    icon: 'success',
                    title: 'Copied!',
                    text: 'All Aadhar UID numbers copied to clipboard',
                    confirmButtonColor: '#667eea',
                    timer: 2000
                });
            });
        }
        
        // Auto format ration number input
        document.querySelector('[name="ration_number"]')?.addEventListener('input', function(e) {
            this.value = this.value.replace(/\D/g, '');
        });
    </script>
</body>
</html>
