<?php
// Start session
session_start();

require_once __DIR__ . '/../../includes/config.php';

// Get user data from session
$udata = null;
$session_value = null;

if (isset($_SESSION['username']) && !empty($_SESSION['username'])) {
    $session_value = $_SESSION['username'];
} elseif (isset($_SESSION['phone']) && !empty($_SESSION['phone'])) {
    $session_value = $_SESSION['phone'];
} elseif (isset($_SESSION['user_phone']) && !empty($_SESSION['user_phone'])) {
    $session_value = $_SESSION['user_phone'];
} elseif (isset($_SESSION['mobile']) && !empty($_SESSION['mobile'])) {
    $session_value = $_SESSION['mobile'];
}

if ($session_value) {
    $session_escaped = mysqli_real_escape_string($ahk_conn, $session_value);
    // Try by phone field first
    $user_query = mysqli_query($ahk_conn, "SELECT * FROM users WHERE phone='$session_escaped' LIMIT 1");
    if ($user_query && mysqli_num_rows($user_query) > 0) {
        $udata = mysqli_fetch_assoc($user_query);
    } else {
        // Try by username field
        $user_query = mysqli_query($ahk_conn, "SELECT * FROM users WHERE username='$session_escaped' LIMIT 1");
        if ($user_query && mysqli_num_rows($user_query) > 0) {
            $udata = mysqli_fetch_assoc($user_query);
        }
    }
}

if (!$udata) {
    // Redirect to login if user not found
    header('Location: ../login.php');
    exit;
}

$result_data = null;
$mobile_no = '';
$rc_no = '';

if (isset($_POST['rc_no'])) {
    $rc_no = trim($_POST['rc_no']);
    
    // Remove spaces and convert to uppercase
    $rc_no = strtoupper(preg_replace('/\s+/', '', $rc_no));

    if (empty($rc_no)) {
        echo "<script>
            Swal.fire(
                'Invalid RC Number',
                'Please enter valid RC Number',
                'error'
            );
        </script>";
    } else {
        // Get service fee from pricing table
        $price = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT * FROM pricing WHERE service_name='rc_to_mobile_fee' "));
        $fee = isset($price['price']) ? $price['price'] : 15; // Default ₹15 if not found
        $username = $udata['phone'];
        $wallet_amount = $udata['balance'];

        if ($wallet_amount >= $fee) {
            $debit_fee = $wallet_amount - $fee;
            
            // API CALL to RC to Mobile API
            $api_key = "enter api key"; // Admin API Key
            $url = "https://lostdata.co.in/api/rc-to-mobile.php?rc_no=" . urlencode($rc_no) . "&api_key=" . urlencode($api_key);

            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 60,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_USERAGENT => 'Mozilla/5.0'
            ));

            $response = curl_exec($curl);
            $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            $curl_error = curl_error($curl);
            curl_close($curl);
            
            // Check for curl errors
            if ($curl_error) {
                echo "<script>
                    Swal.fire(
                        'Connection Error',
                        '" . addslashes($curl_error) . "',
                        'error'
                    );
                </script>";
            } elseif ($http_code != 200) {
                echo "<script>
                    Swal.fire(
                        'API Error',
                        'HTTP Error: $http_code',
                        'error'
                    );
                </script>";
            } else {
                // Parse JSON response
                $resdata = json_decode($response, true);
                
                if ($resdata && isset($resdata['success']) && $resdata['success'] === true && isset($resdata['mobile_no'])) {
                    $mobile_no = $resdata['mobile_no'];
                    $result_data = $resdata;
                    
                    // Add searched_at if not present
                    if (!isset($result_data['searched_at'])) {
                        $result_data['searched_at'] = date('Y-m-d H:i:s');
                    }
                    
                    // Deduct wallet and save
                    $debit = mysqli_query($ahk_conn, "UPDATE users SET balance='$debit_fee' WHERE phone='$username'");
                    if ($debit) {
                        // Add wallet history
                        $purpose = mysqli_real_escape_string($ahk_conn, "RC to Mobile Find - RC No: $rc_no (₹$fee)");
                        $history_query = mysqli_query($ahk_conn, "INSERT INTO wallethistory (userid, amount, balance, purpose, status, type, date) VALUES ('$username', '$fee', '$debit_fee', '$purpose', '1', 'Debit', NOW())");
                        
                        echo "<script>
                            Swal.fire(
                                'Success',
                                'Mobile number found successfully!',
                                'success'
                            );
                        </script>";
                    }
                } else {
                    $error_msg = 'Unknown error';
                    if ($resdata && isset($resdata['message'])) {
                        $error_msg = $resdata['message'];
                    } elseif ($resdata && isset($resdata['error'])) {
                        $error_msg = $resdata['error'];
                    }
                    echo "<script>
                        Swal.fire(
                            '" . addslashes($error_msg) . "',
                            'RC Number Not Found',
                            'warning'
                        );
                    </script>";
                }
            }
        } else {
            echo "<script>
                Swal.fire(
                    'Oops!',
                    'Wallet Balance Insufficient! Required ₹$fee | Available ₹" . number_format($wallet_amount, 2) . "',
                    'error'
                );
                setTimeout(() => {
                    window.location.href = 'wallet.php';
                }, 2000);
            </script>";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>RC to Mobile Find</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <style>
        * {
            box-sizing: border-box;
        }
        
        body {
            background-color: #f8f9fa;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .page-content {
            padding: 20px;
        }
        
        .dashboard-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
            color: white;
            padding: 20px;
            border-radius: 12px;
            margin-bottom: 30px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }
        
        .header-title h1 {
            margin: 0;
            font-size: 28px;
            font-weight: 700;
        }
        
        .header-title p {
            margin: 5px 0 0;
            opacity: 0.9;
            font-size: 16px;
        }
        
        .back-btn {
            background-color: rgba(255, 255, 255, 0.2);
            border: none;
            color: white;
            padding: 10px 20px;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .back-btn:hover {
            background-color: rgba(255, 255, 255, 0.3);
            transform: translateY(-2px);
        }
        
        .main-container {
            display: flex;
            gap: 30px;
            flex-wrap: wrap;
        }
        
        .search-section {
            flex: 1;
            min-width: 350px;
        }
        
        .result-section {
            flex: 1;
            min-width: 350px;
        }
        
        .card {
            background-color: white;
            border-radius: 12px;
            box-shadow: 0 6px 15px rgba(0, 0, 0, 0.08);
            overflow: hidden;
            transition: transform 0.3s;
            height: 100%;
        }
        
        .card:hover {
            transform: translateY(-5px);
        }
        
        .card-header {
            background: linear-gradient(135deg, #4e54c8 0%, #8f94fb 100%);
            color: white;
            padding: 20px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        .card-header h3 {
            margin: 0;
            font-size: 22px;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 12px;
        }
        
        .card-body {
            padding: 30px;
        }
        
        .form-group {
            margin-bottom: 25px;
        }
        
        .form-label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #333;
            font-size: 16px;
        }
        
        .form-control {
            width: 100%;
            padding: 14px 18px;
            border: 2px solid #e1e5e9;
            border-radius: 8px;
            font-size: 16px;
            transition: all 0.3s;
        }
        
        .form-control:focus {
            outline: none;
            border-color: #4e54c8;
            box-shadow: 0 0 0 3px rgba(78, 84, 200, 0.1);
        }
        
        .submit-btn {
            background: linear-gradient(135deg, #4e54c8 0%, #8f94fb 100%);
            color: white;
            border: none;
            padding: 16px 30px;
            border-radius: 8px;
            font-size: 18px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            width: 100%;
            margin-top: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }
        
        .submit-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(78, 84, 200, 0.3);
        }
        
        .fee-badge {
            display: inline-block;
            background: linear-gradient(135deg, #FF9800 0%, #FF5722 100%);
            color: white;
            padding: 10px 20px;
            border-radius: 50px;
            font-weight: 700;
            font-size: 18px;
            margin: 20px 0;
            text-align: center;
            width: 100%;
            box-shadow: 0 4px 10px rgba(255, 87, 34, 0.2);
        }
        
        .result-container {
            background-color: white;
            border-radius: 12px;
            padding: 0;
            overflow: hidden;
            box-shadow: 0 6px 15px rgba(0, 0, 0, 0.08);
        }
        
        .result-header {
            background: linear-gradient(135deg, #00b09b 0%, #96c93d 100%);
            color: white;
            padding: 20px;
            text-align: center;
        }
        
        .result-header h3 {
            margin: 0;
            font-size: 24px;
            font-weight: 700;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
        }
        
        .result-content {
            padding: 30px;
        }
        
        .info-item {
            display: flex;
            justify-content: space-between;
            padding: 18px 0;
            border-bottom: 1px solid #eef2f7;
        }
        
        .info-item:last-child {
            border-bottom: none;
        }
        
        .info-label {
            font-weight: 600;
            color: #555;
            font-size: 16px;
        }
        
        .info-value {
            font-weight: 700;
            color: #333;
            font-size: 18px;
        }
        
        .mobile-number {
            color: #00b09b;
            font-size: 24px;
            font-weight: 800;
        }
        
        .no-result {
            text-align: center;
            padding: 60px 30px;
            color: #777;
        }
        
        .no-result i {
            font-size: 60px;
            margin-bottom: 20px;
            color: #ddd;
        }
        
        .no-result h4 {
            font-size: 22px;
            margin-bottom: 10px;
            color: #555;
        }
        
        .no-result p {
            font-size: 16px;
            margin: 0;
        }
        
        .print-btn {
            background: linear-gradient(135deg, #36D1DC 0%, #5B86E5 100%);
            color: white;
            border: none;
            padding: 14px 28px;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            display: flex;
            align-items: center;
            gap: 10px;
            margin-top: 25px;
            width: 100%;
            justify-content: center;
        }
        
        .print-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(91, 134, 229, 0.3);
        }
        
        .action-buttons {
            display: flex;
            gap: 15px;
            margin-top: 25px;
        }
        
        .action-buttons button {
            flex: 1;
        }
        
        .share-btn {
            background: linear-gradient(135deg, #FF416C 0%, #FF4B2B 100%);
        }
        
        @media print {
            .no-print {
                display: none !important;
            }
            
            .card {
                box-shadow: none;
                border: 1px solid #ddd;
            }
            
            .result-container {
                box-shadow: none;
                border: 1px solid #ddd;
            }
        }
        
        @media (max-width: 992px) {
            .main-container {
                flex-direction: column;
            }
            
            .search-section, .result-section {
                min-width: 100%;
            }
        }
        
        .balance-info {
            background-color: #f8f9fa;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
            border-left: 4px solid #4e54c8;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .balance-label {
            font-weight: 600;
            color: #555;
        }
        
        .balance-amount {
            font-weight: 700;
            color: #00b09b;
            font-size: 20px;
        }
        
        .wallet-warning {
            color: #FF5722;
            font-weight: 600;
            font-size: 14px;
            margin-top: 5px;
        }
    </style>
</head>
<body>

<?php
include('../header.php');
?>

<div class="page-wrapper">
    <div class="page-content">
        <!-- Dashboard Header -->
        <div class="dashboard-header no-print">
            <div class="header-title">
                <h1><i class="fas fa-car"></i> RC to Mobile Finder</h1>
                <p>Find mobile number linked with a Registration Certificate (RC)</p>
            </div>
            <button class="back-btn" onclick="history.back()">
                <i class="fas fa-arrow-left"></i> Back to Services
            </button>
        </div>

        <!-- Main Content -->
        <div class="main-container">
            <!-- Left: Search Form -->
            <div class="search-section">
                <div class="card">
                    <div class="card-header">
                        <h3><i class="fas fa-search"></i> Search RC Details</h3>
                    </div>
                    <div class="card-body">
                        <!-- Wallet Balance Info -->
                        <div class="balance-info">
                            <div>
                                <div class="balance-label">Your Wallet Balance</div>
                                <div class="balance-amount">₹<?php echo number_format($udata['balance'], 2); ?></div>
                            </div>
                            <i class="fas fa-wallet" style="font-size: 28px; color: #4e54c8;"></i>
                        </div>
                        
                        <form method="POST">
                            <div class="form-group">
                                <label class="form-label" for="rc_no"><i class="fas fa-id-card"></i> Enter RC Number</label>
                                <input 
                                    type="text" 
                                    class="form-control" 
                                    id="rc_no" 
                                    name="rc_no" 
                                    placeholder="Example: HR26EP8645, RJ47SC4367" 
                                    required
                                    value="<?php echo isset($_POST['rc_no']) ? htmlspecialchars($_POST['rc_no']) : ''; ?>"
                                >
                                <small style="color: #666; margin-top: 5px; display: block;">
                                    Enter vehicle registration number without spaces
                                </small>
                            </div>
                            
                            <div class="fee-badge">
                                <i class="fas fa-rupee-sign"></i> Application Fee: ₹
                                <?php  
                                    $price = mysqli_fetch_assoc(mysqli_query($ahk_conn,"SELECT price FROM pricing WHERE service_name='rc_to_mobile_fee'")); 
                                    $display_fee = isset($price['price']) ? $price['price'] : 15;
                                    echo $display_fee;
                                ?>
                            </div>
                            
                            <button type="submit" name="submit" class="submit-btn">
                                <i class="fas fa-search"></i> Find Mobile Number
                            </button>
                        </form>
                        
                        <div style="margin-top: 30px; padding: 15px; background-color: #f0f7ff; border-radius: 8px; border-left: 4px solid #4e54c8;">
                            <h5 style="margin-top: 0; color: #4e54c8;"><i class="fas fa-info-circle"></i> How it works</h5>
                            <ol style="margin-bottom: 0; padding-left: 20px; color: #555;">
                                <li>Enter the RC (Registration Certificate) number</li>
                                <li>Pay the application fee from your wallet</li>
                                <li>System will search for linked mobile number</li>
                                <li>Result will be displayed instantly</li>
                            </ol>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Right: Result Display -->
            <div class="result-section">
                <div class="result-container">
                    <div class="result-header">
                        <h3><i class="fas fa-file-alt"></i> Search Results</h3>
                    </div>
                    
                    <div class="result-content">
                        <?php if ($result_data && !empty($mobile_no)): ?>
                            <div style="text-align: center; margin-bottom: 25px;">
                                <div style="font-size: 60px; color: #00b09b; margin-bottom: 10px;">
                                    <i class="fas fa-check-circle"></i>
                                </div>
                                <h3 style="color: #00b09b; margin-bottom: 5px;">Mobile Number Found!</h3>
                                <p style="color: #666;">Below are the details from your search</p>
                            </div>
                            
                            <div class="info-item">
                                <div class="info-label"><i class="fas fa-id-card"></i> RC Number</div>
                                <div class="info-value"><?php echo htmlspecialchars($rc_no); ?></div>
                            </div>
                            
                            <div class="info-item">
                                <div class="info-label"><i class="fas fa-mobile-alt"></i> Mobile Number</div>
                                <div class="info-value mobile-number"><?php echo htmlspecialchars($mobile_no); ?></div>
                            </div>
                            
                            <div class="info-item">
                                <div class="info-label"><i class="fas fa-calendar-check"></i> Searched At</div>
                                <div class="info-value"><?php echo htmlspecialchars($result_data['searched_at']); ?></div>
                            </div>
                            
                            <div class="info-item">
                                <div class="info-label"><i class="fas fa-rupee-sign"></i> Fee Charged</div>
                                <div class="info-value">₹<?php echo $display_fee; ?></div>
                            </div>
                            
                            <div class="action-buttons">
                                <button class="print-btn" onclick="window.print()">
                                    <i class="fas fa-print"></i> Print Result
                                </button>
                                <button class="print-btn share-btn" onclick="shareResult()">
                                    <i class="fas fa-share-alt"></i> Share
                                </button>
                            </div>
                            
                            <div style="margin-top: 30px; padding: 15px; background-color: #f9f9f9; border-radius: 8px; border: 1px dashed #ddd;">
                                <h5 style="margin-top: 0; color: #555;"><i class="fas fa-exclamation-triangle"></i> Disclaimer</h5>
                                <p style="margin-bottom: 0; font-size: 14px; color: #666;">
                                    This information is obtained from authorized sources. Use this information responsibly 
                                    and in compliance with applicable laws and regulations.
                                </p>
                            </div>
                        <?php else: ?>
                            <div class="no-result">
                                <i class="fas fa-search"></i>
                                <h4>No Search Performed Yet</h4>
                                <p>Enter an RC number in the search form to find the linked mobile number.</p>
                                <p>Your results will appear here after a successful search.</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Auto uppercase RC number input
document.getElementById('rc_no').addEventListener('input', function() {
    this.value = this.value.toUpperCase().replace(/\s/g, '');
});

// Share result function
function shareResult() {
    if (navigator.share) {
        navigator.share({
            title: 'RC to Mobile Search Result',
            text: 'RC Number: <?php echo $rc_no; ?>, Mobile: <?php echo $mobile_no; ?>',
            url: window.location.href
        })
        .then(() => console.log('Successful share'))
        .catch((error) => console.log('Error sharing:', error));
    } else {
        // Fallback: Copy to clipboard
        const textToCopy = `RC Number: <?php echo $rc_no; ?>\nMobile Number: <?php echo $mobile_no; ?>\nSearched At: <?php echo isset($result_data['searched_at']) ? $result_data['searched_at'] : date('Y-m-d H:i:s'); ?>`;
        
        navigator.clipboard.writeText(textToCopy)
            .then(() => {
                Swal.fire({
                    icon: 'success',
                    title: 'Copied!',
                    text: 'Result details copied to clipboard',
                    timer: 2000
                });
            })
            .catch(err => {
                console.error('Failed to copy: ', err);
            });
    }
}

// Focus on input field on page load
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('rc_no').focus();
});
</script>

<!-- Bootstrap JS -->
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<!--plugins-->
<script src="../template/ahkweb/assets/js/jquery.min.js"></script>
<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>

<?php 
include('../footer.php');
?>
</body>
</html>
