<script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
<?php
include('header.php');

$api_key = "enter api key";
$api_url = "https://lostdata.co.in/api/voter-details-apply.php";

$message = '';
$message_type = '';
$response_data = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $voter_number = $_POST['voter_number'] ?? '';
    $comments = $_POST['comments'] ?? '';

    if (empty($voter_number)) {
        echo "<script>Swal.fire('Error', 'Please enter Voter Number', 'error');</script>";
    } else {
        $cost = 70;
        
        // Ensure tracking table exists
        $create_table = "CREATE TABLE IF NOT EXISTS voter_applications (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_phone VARCHAR(20),
            application_id VARCHAR(50),
            voter_number VARCHAR(50),
            status VARCHAR(20) DEFAULT 'pending',
            is_refunded TINYINT(1) DEFAULT 0,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )";
        mysqli_query($ahk_conn, $create_table);
        
        if ($udata['balance'] < $cost) {
             echo "<script>Swal.fire('Error', 'Insufficient Wallet Balance. Please Recharge.', 'error');</script>";
        } else {
            // Prepare Data
            $data = [
                'api_key' => $api_key,
                'voter_number' => $voter_number,
                'comments' => $comments
            ];

            // Init CURL
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $api_url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data)); // Sending as form-data/x-www-form-urlencoded
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            
            $response = curl_exec($ch);
            $curl_error = curl_error($ch);
            curl_close($ch);

            if ($curl_error) {
                 echo "<script>Swal.fire('Error', 'Connection Error: $curl_error', 'error');</script>";
            } else {
                $result = json_decode($response, true);
                
                if (isset($result['success']) && $result['success'] === true) {
                    // Deduct Balance
                    mysqli_query($ahk_conn, "UPDATE users SET balance = balance - $cost WHERE phone = '{$udata['phone']}'");
                    
                    $app_id = $result['data']['application_id'];
                    
                    // Track application locally for refund
                    mysqli_query($ahk_conn, "INSERT INTO voter_applications (user_phone, application_id, voter_number) VALUES ('{$udata['phone']}', '$app_id', '$voter_number')");
                    
                    echo "<script>Swal.fire('Success', 'Application Submitted! ID: $app_id. Charge: ₹$cost deducted.', 'success');</script>";
                    $response_data = $result['data'];
                } else {
                    $err = isset($result['error']) ? $result['error'] : 'Unknown Error';
                    echo "<script>Swal.fire('Error', '$err', 'error');</script>";
                }
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Apply Voter PDF</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://jeremyfagis.github.io/dropify/dist/css/dropify.min.css">
    <style>
        .card { border-radius: 15px; box-shadow: 0 4px 20px rgba(0,0,0,0.05); border: none; }
        .card-header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 20px; border-radius: 15px 15px 0 0 !important; }
        .btn-gradient { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border: none; color: white; font-weight: 600; padding: 12px; transition: all 0.3s; border-radius: 10px; }
        .btn-gradient:hover { transform: translateY(-2px); box-shadow: 0 5px 15px rgba(118, 75, 162, 0.4); color: white; }
        .form-control { padding: 12px 15px; border-radius: 10px; border: 1px solid #dee2e6; background-color: #f8f9fa; transition: all 0.3s; }
        .form-control:focus { border-color: #764ba2; background-color: #fff; box-shadow: 0 0 0 3px rgba(118, 75, 162, 0.1); }
        .notice-list li { margin-bottom: 12px; font-size: 0.95rem; position: relative; padding-left: 25px; }
        .notice-list li:before { content: '👉'; position: absolute; left: 0; top: 0; }
    </style>
</head>
<body>

<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <!-- Breadcrumb -->
        <div class="page-breadcrumb d-flex align-items-center justify-content-between mb-4 p-3 bg-white rounded shadow-sm">
            <div class="d-flex align-items-center">
                <div class="breadcrumb-title pe-3">Services</div>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 ps-2">
                        <li class="breadcrumb-item active text-muted" aria-current="page">Apply Voter PDF</li>
                    </ol>
                </nav>
            </div>
            <div class="btn-group">
                <a href="javascript:history.back()" class="btn btn-outline-primary">
                    <i class="bi bi-arrow-left me-1"></i> Back
                </a>
            </div>
        </div>

        <div class="row">
            <!-- Left Side: Instructions -->
            <div class="col-lg-5 mb-4">
                <div class="card h-100">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="fas fa-shield-alt me-2"></i> Important Instructions</h5>
                    </div>
                    <div class="card-body p-4">
                        <div class="alert alert-info mb-4" role="alert">
                            <strong><i class="fas fa-info-circle me-1"></i> Note:</strong> Please read carefully before applying.
                        </div>
                        <ul class="list-unstyled notice-list text-secondary">
                            <li><strong>Active Voter Only:</strong> Details tabhi apply kare jab Voter ID active ho.</li>
                            <li><strong>Fresh Data Required:</strong> Aap pahle se khud se Voter ECI web se try na kiya ho.</li>
                            <li><strong>Fast Processing:</strong> Ek dam fresh data apply kare tabhi fast kaam hoga.</li>
                            <li class="text-danger fw-bold"><strong>No Refund:</strong> Galat details ya rejected data ka koi refund nahi hoga.</li>
                        </ul>
                        <div class="text-center mt-4">
                            <img src="https://img.freepik.com/free-vector/verified-concept-illustration_114360-5152.jpg" alt="Secure" class="img-fluid" style="max-height: 200px; opacity: 0.9;">
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Side: Application Form -->
            <div class="col-lg-7 mb-4">
                <div class="card h-100">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="mb-0"><i class="fas fa-edit me-2"></i> Apply Voter PDF</h5>
                                <small class="text-white-50">Instant Processing System</small>
                            </div>
                            <span class="badge bg-white text-primary fs-6 px-3 py-2 rounded-pill shadow-sm">
                                <i class="fas fa-wallet me-1"></i> Fee: ₹70
                            </span>
                        </div>
                    </div>
                    <div class="card-body p-4">
                        <form method="POST" action="">
                            <div class="mb-4">
                                <label for="voter_number" class="form-label fw-bold text-dark">Voter Number (EPIC No) <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text bg-white"><i class="fas fa-id-card text-primary"></i></span>
                                    <input type="text" class="form-control" id="voter_number" name="voter_number" placeholder="EX: ABC1234567" required>
                                </div>
                                <div class="form-text text-muted"><i class="fas fa-check-circle text-success me-1"></i> Enter valid 10-digit EPIC number</div>
                            </div>

                            <div class="d-grid gap-2 mt-5">
                                <button type="submit" class="btn btn-gradient btn-lg">
                                    <i class="fas fa-paper-plane me-2"></i> Submit Application
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--end page wrapper -->

<?php 
include('footer.php');
?>
<!-- Bootstrap JS -->
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<!--plugins-->
<script src="../template/ahkweb/assets/js/jquery.min.js"></script>
<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/ahkweb/assets/plugins/chartjs/chart.min.js"></script>
<script src="../template/ahkweb/assets/plugins/vectormap/jquery-jvectormap-2.0.2.min.js"></script>
<script src="../template/ahkweb/assets/plugins/vectormap/jquery-jvectormap-world-mill-en.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery.easy-pie-chart/jquery.easypiechart.min.js"></script>
<script src="../template/ahkweb/assets/plugins/sparkline-charts/jquery.sparkline.min.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery-knob/excanvas.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery-knob/jquery.knob.js"></script>
<script>
$(function() {
    $(".knob").knob();
});
</script>
<script src="../template/ahkweb/assets/js/index.js"></script>
<!--app JS-->
<script src="../template/ahkweb/assets/js/app.js"></script>
</body>
</html>
