
<?php
include('header.php');

$username = $udata['phone'];

// Get API key for main website
$api_key = "enter api key"; // Admin API Key
$api_url = "https://lostdata.co.in/api/voter-details-status.php";

// Ensure tracking table exists to prevent SQL errors
$create_table = "CREATE TABLE IF NOT EXISTS voter_applications (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_phone VARCHAR(20),
    application_id VARCHAR(50),
    voter_number VARCHAR(50),
    status VARCHAR(20) DEFAULT 'pending',
    is_refunded TINYINT(1) DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
)";
if(isset($ahk_conn)){
    mysqli_query($ahk_conn, $create_table);
}

// Fetch applications from API (Main Website Database)
$url = $api_url . "?api_key=" . urlencode($api_key);

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_SSL_VERIFYPEER => false
]);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curl_error = curl_error($ch);
curl_close($ch);

$applications_data = [];
$stats = ['total' => 0, 'pending' => 0, 'completed' => 0, 'rejected' => 0];
$api_error = '';
$debug_info = '';

if ($curl_error) {
    $api_error = "cURL Error: $curl_error";
    $debug_info = "URL: $url | cURL Error: $curl_error";
} elseif ($http_code == 200 && !empty($response)) {
    $result = json_decode($response, true);
    if (isset($result['success']) && $result['success'] === true) {
        $all_apps = $result['data'] ?? [];
        
        // Filter applications (API should filter by API user automatically)
        $applications_data = $all_apps;
        
        $refund_alerts = [];
        
        // Calculate stats & Process Refunds
        foreach ($applications_data as $app) {
            $stats['total']++;
            $status = strtolower($app['status'] ?? 'pending');
            $app_id = $app['id'];
            
            if ($status === 'pending') {
                $stats['pending']++;
            } elseif (in_array($status, ['completed', 'approved'])) {
                $stats['completed']++;
            } elseif ($status === 'rejected') {
                $stats['rejected']++;
                
                // REFUND LOGIC
                // Check local tracking table for this app
                $check_q = mysqli_query($ahk_conn, "SELECT * FROM voter_applications WHERE application_id='$app_id' AND is_refunded=0 LIMIT 1");
                if ($check_q && mysqli_num_rows($check_q) > 0) {
                     $local_app = mysqli_fetch_assoc($check_q);
                     $refund_amt = 70;
                     $u_phone = $local_app['user_phone'];
                     
                     // Refund to Wallet
                     mysqli_query($ahk_conn, "UPDATE users SET balance = balance + $refund_amt WHERE phone = '$u_phone'");
                     // Mark as refunded
                     mysqli_query($ahk_conn, "UPDATE voter_applications SET status='rejected', is_refunded=1 WHERE id='{$local_app['id']}'");
                     
                     $refund_alerts[] = "Application #$app_id Rejected. ₹$refund_amt Refunded.";
                }
            }
        }
        
        $debug_info = "Success: Found " . count($applications_data) . " applications";
    } else {
        $api_error = $result['error'] ?? $result['message'] ?? 'Unknown API error';
        $debug_info = "API Response: " . substr($response, 0, 200);
    }
} else {
    $api_error = "API Error: HTTP Code $http_code";
    if (!empty($response)) {
        $error_result = json_decode($response, true);
        $api_error .= ' - ' . ($error_result['error'] ?? $error_result['message'] ?? 'No response');
        $debug_info = "Response: " . substr($response, 0, 500);
    } else {
        $debug_info = "No response from API";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Voter Details Applications - Lost Data Solutions</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <style>
        .card { border-radius: 15px; box-shadow: 0 4px 20px rgba(0,0,0,0.05); border: none; }
        .card-header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 20px; border-radius: 15px 15px 0 0 !important; }
        .btn-primary { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border: none; }
        .page-breadcrumb .breadcrumb-title { border-right: 1px solid #e0e0e0; }
    </style>
</head>
<body>

<!--start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <!-- Breadcrumb -->
        <div class="page-breadcrumb d-flex align-items-center justify-content-between mb-4 p-3 bg-white rounded shadow-sm">
            <div class="d-flex align-items-center">
                <div class="breadcrumb-title pe-3">Services</div>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 ps-2">
                        <li class="breadcrumb-item active text-muted" aria-current="page">Voter Details List</li>
                    </ol>
                </nav>
            </div>
            <div class="btn-group">
                 <a href="voter-apply.php" class="btn btn-primary">
                    <i class="fas fa-plus me-1"></i>New Application
                </a>
            </div>
        </div>

        <div class="card">
            <div class="card-body">

                <!-- Statistics -->
                <div class="row mb-4">
                    <div class="col-md-3">
                        <div class="card bg-primary text-white">
                            <div class="card-body text-center">
                                <h3><?php echo $stats['total']; ?></h3>
                                <p class="mb-0">Total Applications</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-warning text-dark">
                            <div class="card-body text-center">
                                <h3><?php echo $stats['pending']; ?></h3>
                                <p class="mb-0">Pending</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-success text-white">
                            <div class="card-body text-center">
                                <h3><?php echo $stats['completed']; ?></h3>
                                <p class="mb-0">Completed</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-danger text-white">
                            <div class="card-body text-center">
                                <h3><?php echo $stats['rejected']; ?></h3>
                                <p class="mb-0">Rejected</p>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if($api_error): ?>
                    <div class="alert alert-danger">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <strong>API Error:</strong> <?php echo htmlspecialchars($api_error); ?>
                        <?php if($debug_info): ?>
                            <br><small>Debug: <?php echo htmlspecialchars($debug_info); ?></small>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>

                <?php if(!empty($refund_alerts)): ?>
                    <?php foreach($refund_alerts as $alert): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="fas fa-check-circle me-2"></i> <?php echo $alert; ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>

                <?php if(count($applications_data) == 0 && !$api_error): ?>
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        No applications found.
                        <br><small>If you just applied, please wait a moment and refresh the page.</small>
                    </div>
                <?php endif; ?>

                <?php if(count($applications_data) > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-hover table-striped" id="applicationsTable">
                            <thead class="table-dark">
                                <tr>
                                    <th>ID</th>
                                    <th>Application No</th>
                                    <th>Voter Number</th>
                                    <th>Fee</th>
                                    <th>Status</th>
                                    <th>Certificate</th>
                                    <th>Applied Date</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($applications_data as $app): 
                                    $app_id = $app['id'] ?? 0;
                                    $app_no = $app['application_no'] ?? 'VD' . $app_id;
                                    $voter_number = htmlspecialchars($app['voter_number'] ?? 'N/A');
                                    $fee = 70; // All in one wallet fee (₹70), not API fee
                                    $status = strtolower($app['status'] ?? 'pending');
                                    $created_at = $app['created_at'] ?? '';
                                    
                                    // Status badge
                                    $status_class = 'warning';
                                    $status_text = ucfirst($status);
                                    if ($status === 'completed' || $status === 'approved') {
                                        $status_class = 'success';
                                    } elseif ($status === 'rejected') {
                                        $status_class = 'danger';
                                    }
                                ?>
                                <tr>
                                    <td>#<?php echo $app_id; ?></td>
                                    <td><strong><?php echo $app_no; ?></strong></td>
                                    <td><?php echo $voter_number; ?></td>
                                    <td>₹<?php echo number_format($fee, 2); ?></td>
                                    <td>
                                        <span class="badge bg-<?php echo $status_class; ?>">
                                            <?php echo $status_text; ?>
                                        </span>
                                    </td>
                                    <td>
                                        <span class="text-muted" id="cert-<?php echo $app_id; ?>">-</span>
                                    </td>
                                    <td><?php echo $created_at ? date('d M Y, h:i A', strtotime($created_at)) : 'N/A'; ?></td>
                                    <td>
                                        <button class="btn btn-sm btn-info" onclick="viewDetails(<?php echo $app_id; ?>)">
                                            <i class="fas fa-eye"></i> View Details
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>

            </div>
        </div>
    </div>
</div>
<!--end page wrapper -->

<!-- View Details Modal -->
<div class="modal fade" id="detailsModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="fas fa-vote-yea me-2"></i>Application Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="modalBody">
                <div class="text-center">
                    <div class="spinner-border" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php 
include('footer.php');
?>
<!-- Bootstrap JS -->
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<!--plugins-->
<script src="../template/ahkweb/assets/js/jquery.min.js"></script>
<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
<script src="../template/ahkweb/assets/plugins/chartjs/chart.min.js"></script>
<script src="../template/ahkweb/assets/plugins/vectormap/jquery-jvectormap-2.0.2.min.js"></script>
<script src="../template/ahkweb/assets/plugins/vectormap/jquery-jvectormap-world-mill-en.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery.easy-pie-chart/jquery.easypiechart.min.js"></script>
<script src="../template/ahkweb/assets/plugins/sparkline-charts/jquery.sparkline.min.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery-knob/excanvas.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery-knob/jquery.knob.js"></script>
<script>
$(function() {
    $(".knob").knob();
});

$(document).ready(function() {
    $('#applicationsTable').DataTable({
        order: [[0, 'desc']],
        pageLength: 10,
        language: {
            search: "Search:",
            lengthMenu: "Show _MENU_ entries",
            info: "Showing _START_ to _END_ of _TOTAL_ entries",
            paginate: {
                first: "First",
                last: "Last",
                next: "Next",
                previous: "Previous"
            }
        }
    });
    
    // Load certificate URLs for all applications
    <?php foreach($applications_data as $app): ?>
    loadCertificate(<?php echo $app['id']; ?>);
    <?php endforeach; ?>
});

function loadCertificate(appId) {
    var apiUrl = 'https://lostdata.co.in/api/voter-details-status.php?api_key=<?php echo urlencode($api_key); ?>&app_id=' + appId;
    
    $.ajax({
        url: apiUrl,
        method: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.success && response.application && response.application.certificate_url) {
                $('#cert-' + appId).html(
                    '<a href="' + response.application.certificate_url + '" target="_blank" class="btn btn-sm btn-success">' +
                    '<i class="fas fa-download"></i> Download</a>'
                );
            }
        },
        error: function() {
            // Silently fail - don't disturb user
        }
    });
}

function viewDetails(appId) {
    $('#detailsModal').modal('show');
    $('#modalBody').html('<div class="text-center"><div class="spinner-border" role="status"><span class="visually-hidden">Loading...</span></div></div>');
    
    // Fetch application details from API
    var apiUrl = 'https://lostdata.co.in/api/voter-details-status.php?api_key=<?php echo urlencode($api_key); ?>&app_id=' + appId;
    
    $.ajax({
        url: apiUrl,
        method: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.success && response.application) {
                var app = response.application;
                
                var html = '<div class="mb-3">';
                html += '<p><strong>Application ID:</strong> #' + app.id + '</p>';
                html += '<p><strong>Application No:</strong> ' + (app.application_no || 'VD' + app.id) + '</p>';
                html += '<p><strong>Voter Number:</strong> ' + (app.voter_number || 'N/A') + '</p>';
                if (app.voter_name) {
                    html += '<p><strong>Voter Name:</strong> ' + app.voter_name + '</p>';
                }
                if (app.father_name) {
                    html += '<p><strong>Father\'s Name:</strong> ' + app.father_name + '</p>';
                }
                if (app.address) {
                    html += '<p><strong>Address:</strong> ' + app.address + '</p>';
                }
                if (app.age) {
                    html += '<p><strong>Age:</strong> ' + app.age + '</p>';
                }
                if (app.gender) {
                    html += '<p><strong>Gender:</strong> ' + app.gender + '</p>';
                }
                html += '<p><strong>Fee:</strong> ₹70.00</p>'; // All in one wallet fee
                html += '<p><strong>Status:</strong> <span class="badge bg-' + (app.status === 'completed' ? 'success' : 'warning') + '">' + (app.status || 'pending') + '</span></p>';
                if (app.remark) {
                    html += '<p><strong>Remark:</strong> ' + app.remark + '</p>';
                }
                if (app.certificate_url) {
                    html += '<p><strong>Certificate:</strong> <a href="' + app.certificate_url + '" target="_blank" class="btn btn-sm btn-primary"><i class="fas fa-download"></i> Download</a></p>';
                }
                html += '<p><strong>Applied Date:</strong> ' + (app.created_at || 'N/A') + '</p>';
                if (app.completed_date) {
                    html += '<p><strong>Completed Date:</strong> ' + app.completed_date + '</p>';
                }
                html += '</div>';
                
                $('#modalBody').html(html);
            } else {
                $('#modalBody').html('<div class="alert alert-danger">Failed to load application details: ' + (response.message || 'Unknown error') + '</div>');
            }
        },
        error: function(xhr, status, error) {
            $('#modalBody').html('<div class="alert alert-danger">Error loading application details: ' + error + '</div>');
        }
    });
}
</script>
<script src="../template/ahkweb/assets/js/index.js"></script>
<!--app JS-->
<script src="../template/ahkweb/assets/js/app.js"></script>
</body>
</html>
