<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PAN Without Aadhar Applications - Lost Data Solutions</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
</head>
<body>

<?php
include('../header.php');

$username = $udata['phone'];

// Get API key for main website
$api_key = "enter api key"; // Admin API Key
$api_url = "https://lostdata.co.in/api/without_status.php";

// Fetch applications from API (Main Website Database) - Filter by current user's phone/username
$url = $api_url . "?api_key=" . urlencode($api_key) . "&username=" . urlencode($username);

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_SSL_VERIFYPEER => false
]);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curl_error = curl_error($ch);
curl_close($ch);

$applications_data = [];
$stats = ['total' => 0, 'pending' => 0, 'completed' => 0, 'rejected' => 0];
$api_error = '';
$debug_info = '';

if ($curl_error) {
    $api_error = "cURL Error: $curl_error";
    $debug_info = "URL: $url | cURL Error: $curl_error";
} elseif ($http_code == 200 && !empty($response)) {
    $result = json_decode($response, true);
    if (isset($result['success']) && $result['success'] === true) {
        $applications_data = $result['data'] ?? [];
        $stats = $result['statistics'] ?? $stats;
        $debug_info = "Success: Found " . count($applications_data) . " applications";
    } else {
        $api_error = $result['error'] ?? $result['message'] ?? 'Unknown API error';
        $debug_info = "API Response: " . substr($response, 0, 200);
    }
} else {
    $api_error = "API Error: HTTP Code $http_code";
    if (!empty($response)) {
        $error_result = json_decode($response, true);
        $api_error .= ' - ' . ($error_result['error'] ?? $error_result['message'] ?? 'No response');
        $debug_info = "Response: " . substr($response, 0, 500);
    } else {
        $debug_info = "No response from API";
    }
}
?>

<div class="page-wrapper">
<div class="page-content">
<div class="card">
<div class="card-body">

<div class="d-flex justify-content-between align-items-center mb-3">
    <h4><i class="fas fa-history me-2"></i>PAN Without Aadhar Applications</h4>
    <a href="without-apply.php" class="btn btn-primary">
        <i class="fas fa-plus me-1"></i>New Application
    </a>
</div>

<!-- Statistics -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body text-center">
                <h3><?php echo $stats['total']; ?></h3>
                <p class="mb-0">Total Applications</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-warning text-dark">
            <div class="card-body text-center">
                <h3><?php echo $stats['pending']; ?></h3>
                <p class="mb-0">Pending</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body text-center">
                <h3><?php echo $stats['completed']; ?></h3>
                <p class="mb-0">Completed</p>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-danger text-white">
            <div class="card-body text-center">
                <h3><?php echo $stats['rejected']; ?></h3>
                <p class="mb-0">Rejected</p>
            </div>
        </div>
    </div>
</div>

<?php if (!empty($api_error)): ?>
<div class="alert alert-warning mb-3">
    <strong><i class="fas fa-exclamation-triangle me-2"></i>API Error:</strong> <?php echo htmlspecialchars($api_error); ?>
    <br><small>Phone used for filter: <?php echo htmlspecialchars($username); ?></small>
    <?php if (!empty($debug_info)): ?>
    <br><small><strong>Debug:</strong> <?php echo htmlspecialchars($debug_info); ?></small>
    <?php endif; ?>
</div>
<?php endif; ?>

<?php if (empty($api_error) && empty($applications_data)): ?>
<div class="alert alert-info mb-3">
    <strong><i class="fas fa-info-circle me-2"></i>Info:</strong> No applications found for phone: <?php echo htmlspecialchars($username); ?>
    <br><small>If you just applied, please wait a moment and refresh the page.</small>
</div>
<?php endif; ?>

<div class="table-responsive">
    <table id="historyTable" class="table table-striped table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>Application No</th>
                <th>Name</th>
                <th>Father's Name</th>
                <th>DOB</th>
                <th>Phone</th>
                <th>Service Charge</th>
                <th>Status</th>
                <th>Applied Date</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php
            if (!empty($applications_data)) {
                foreach($applications_data as $row) {
                    ?>
                    <tr>
                        <td><?php echo $row['id']; ?></td>
                        <td><strong><?php echo htmlspecialchars($row['application_no'] ?: 'PAN' . $row['id']); ?></strong></td>
                        <td><?php echo htmlspecialchars($row['name']); ?></td>
                        <td><?php echo htmlspecialchars($row['father_name']); ?></td>
                        <td><?php echo htmlspecialchars($row['dob']); ?></td>
                        <td><?php echo htmlspecialchars($row['phone']); ?></td>
                        <td>₹<?php echo number_format($row['fee'], 2); ?></td>
                        <td>
                            <?php 
                            $status = strtolower($row['status'] ?? 'pending');
                            if ($status == 'pending' || $status == 'in-progress'): ?>
                                <span class="badge bg-warning text-dark"><i class="fas fa-clock me-1"></i>Pending</span>
                            <?php elseif ($status == 'completed' || $status == 'approved'): ?>
                                <span class="badge bg-success"><i class="fas fa-check me-1"></i>Completed</span>
                                <?php if (!empty($row['certificate_url'])): ?>
                                    <br><a href="<?php echo htmlspecialchars($row['certificate_url']); ?>" target="_blank" class="btn btn-sm btn-info mt-1"><i class="fas fa-download"></i> Certificate</a>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class="badge bg-danger"><i class="fas fa-times me-1"></i>Rejected</span>
                                <?php if (!empty($row['remark'])): ?>
                                    <br><small class="text-muted"><?php echo htmlspecialchars($row['remark']); ?></small>
                                <?php endif; ?>
                            <?php endif; ?>
                        </td>
                        <td><?php echo date('d/m/Y h:i A', strtotime($row['date'])); ?></td>
                        <td>
                            <button
                                class="btn btn-sm btn-info"
                                onclick="viewDetails(this)"
                                data-row='<?php echo json_encode($row, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_AMP | JSON_HEX_QUOT); ?>'>
                                <i class="fas fa-eye"></i> View Details
                            </button>
                        </td>
                    </tr>
                    <?php
                }
            } else {
                ?>
                <tr>
                    <td colspan="10" class="text-center py-4">
                        <i class="fas fa-inbox fa-2x text-muted mb-2"></i><br>
                        <p class="text-muted">No applications found</p>
                        <a href="without-apply.php" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i>Apply Now
                        </a>
                    </td>
                </tr>
                <?php
            }
            ?>
        </tbody>
    </table>
</div>

</div>
</div>
</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>

<script>
var table;
var refreshInterval;

$(document).ready(function() {
    // Check if table has data rows (not empty state row)
    var hasDataRows = $('#historyTable tbody tr').length > 0 && 
                     !$('#historyTable tbody tr').first().find('td').attr('colspan');
    
    if (hasDataRows) {
        table = $('#historyTable').DataTable({
            order: [[0, 'desc']],
            pageLength: 25,
            responsive: true
        });
        
        // Auto-refresh status every 10 seconds using AJAX (without page reload)
        refreshInterval = setInterval(function() {
            refreshStatus();
        }, 10000); // 10 seconds - Check for status updates
        
        // Also do full page refresh every 2 minutes to ensure data sync
        setInterval(function() {
            location.reload();
        }, 120000); // 2 minutes - Full refresh
    }
});

function refreshStatus() {
    var api_key = "mk_9cbdbbec31ff30393bd8b5d022a4d45b";
    var username = "<?php echo addslashes($username); ?>";
    var api_url = "https://lostdata.co.in/api/without_status.php";
    var url = api_url + "?api_key=" + encodeURIComponent(api_key) + "&username=" + encodeURIComponent(username);
    
    $.ajax({
        url: url,
        method: 'GET',
        timeout: 5000,
        success: function(response) {
            try {
                var result = typeof response === 'string' ? JSON.parse(response) : response;
                if (result.success && result.data) {
                    updateTableStatus(result.data);
                }
            } catch(e) {
                console.log('Status update error:', e);
            }
        },
        error: function() {
            // Silently fail - don't disturb user
        }
    });
}

function updateTableStatus(applications) {
    // Update status badges in table without reloading page
    if (!table) return;
    
    table.rows().every(function() {
        var row = this.node();
        var rowData = this.data();
        var appId = parseInt($(row).find('td:first').text());
        
        // Find matching application from API response
        var matchingApp = applications.find(function(app) {
            return app.id === appId;
        });
        
        if (matchingApp) {
            var statusCell = $(row).find('td').eq(7); // Status column (8th column, 0-indexed = 7)
            var currentStatus = statusCell.find('.badge').text().trim().toLowerCase();
            var newStatus = matchingApp.status ? matchingApp.status.toLowerCase() : 'pending';
            
            // Map status values
            if (newStatus === 'in-progress') newStatus = 'pending';
            if (newStatus === 'approved') newStatus = 'completed';
            
            // Only update if status changed
            if (currentStatus !== newStatus && (currentStatus === 'pending' || newStatus === 'completed' || newStatus === 'approved')) {
                var statusHtml = '';
                if (newStatus === 'pending' || newStatus === 'in-progress') {
                    statusHtml = '<span class="badge bg-warning text-dark"><i class="fas fa-clock me-1"></i>Pending</span>';
                } else if (newStatus === 'completed' || newStatus === 'approved') {
                    statusHtml = '<span class="badge bg-success"><i class="fas fa-check me-1"></i>Completed</span>';
                    if (matchingApp.certificate_url) {
                        statusHtml += '<br><a href="' + matchingApp.certificate_url + '" target="_blank" class="btn btn-sm btn-info mt-1"><i class="fas fa-download"></i> Certificate</a>';
                    }
                    // Show success notification
                    if (currentStatus === 'pending' || currentStatus === 'in-progress') {
                        Swal.fire({
                            icon: 'success',
                            title: 'Application Approved!',
                            text: 'Your PAN application #' + appId + ' has been approved! Certificate is ready.',
                            timer: 3000,
                            showConfirmButton: false,
                            toast: true,
                            position: 'top-end'
                        });
                    }
                } else if (newStatus === 'rejected') {
                    statusHtml = '<span class="badge bg-danger"><i class="fas fa-times me-1"></i>Rejected</span>';
                    if (matchingApp.remark) {
                        statusHtml += '<br><small class="text-muted">' + matchingApp.remark + '</small>';
                    }
                }
                
                statusCell.html(statusHtml);
                
                // Update statistics
                updateStatistics(applications);
            }
        }
    });
}

function updateStatistics(applications) {
    var stats = {
        total: applications.length,
        pending: 0,
        completed: 0,
        rejected: 0
    };
    
    applications.forEach(function(app) {
        var status = app.status ? app.status.toLowerCase() : 'pending';
        if (status === 'pending' || status === 'in-progress') stats.pending++;
        else if (status === 'completed' || status === 'approved') stats.completed++;
        else if (status === 'rejected') stats.rejected++;
    });
    
    // Update stat cards
    $('.card.bg-primary .card-body h3').text(stats.total);
    $('.card.bg-warning .card-body h3').text(stats.pending);
    $('.card.bg-success .card-body h3').text(stats.completed);
    $('.card.bg-danger .card-body h3').text(stats.rejected);
}

function viewDetails(button) {
    // Safely read JSON data from data-row attribute
    var raw = button.getAttribute('data-row');
    if (!raw) return;

    var row;
    try {
        row = JSON.parse(raw);
    } catch (e) {
        console.error('Failed to parse row data', e, raw);
        return;
    }

    var detailsHtml = "<div style='text-align:left; max-height:500px; overflow-y:auto;'>";
    detailsHtml += "<b>Application ID:</b> #" + row.id + "<br>";
    detailsHtml += "<b>Application No:</b> " + (row.application_no || 'PAN' + row.id) + "<br>";
    detailsHtml += "<b>Name:</b> " + row.name + "<br>";
    detailsHtml += "<b>Father's Name:</b> " + row.father_name + "<br>";
    detailsHtml += "<b>DOB:</b> " + row.dob + "<br>";
    detailsHtml += "<b>Gender:</b> " + row.gender + "<br>";
    detailsHtml += "<b>Email:</b> " + (row.email || 'N/A') + "<br>";
    detailsHtml += "<b>Phone:</b> " + row.phone + "<br>";
    detailsHtml += "<b>Mobile:</b> " + row.mobile + "<br>";
    detailsHtml += "<b>Village/Town:</b> " + row.village + "<br>";
    detailsHtml += "<b>Post Office:</b> " + row.post + "<br>";
    detailsHtml += "<b>PIN Code:</b> " + row.pincode + "<br>";
    detailsHtml += "<b>District:</b> " + row.district + "<br>";
    detailsHtml += "<b>State:</b> " + row.state + "<br>";
    detailsHtml += "<b>Service Charge:</b> ₹" + parseFloat(row.fee).toFixed(2) + "<br>";
    detailsHtml += "<b>Status:</b> " + row.status + "<br>";
    detailsHtml += "<b>Applied Date:</b> " + row.date + "<br>";
    
    if (row.ack_number) {
        detailsHtml += "<b>Acknowledgement Number:</b> " + row.ack_number + "<br>";
    }
    
    if (row.remark) {
        detailsHtml += "<b>Remark:</b> " + row.remark + "<br>";
    }
    
    if (row.certificate_url) {
        detailsHtml += "<br><b>PAN Certificate:</b><br>";
        detailsHtml += "<a href='" + row.certificate_url + "' target='_blank' class='btn btn-sm btn-success'><i class='fas fa-download'></i> Download Certificate</a>";
    }
    
    detailsHtml += "</div>";
    
    Swal.fire({
        title: 'PAN Application - Details',
        html: detailsHtml,
        width: 800,
        confirmButtonText: 'Close',
        showCloseButton: true
    });
}
</script>

<?php include('../footer.php'); ?>
</body>
</html>