<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Responses BY HBConnect</title>
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.4.14/dist/sweetalert2.all.min.js"></script>
</head>
<body>

<?php
session_start();
include '../includes/config.php';

if (isset($_SESSION['order_id'])) {
    $order_id = $_SESSION['order_id'];
    $customer_mobile = $_SESSION['customer_mobile'];

    $ta_check = mysqli_query($ahk_conn, "SELECT * FROM wallet WHERE txn_id='$order_id'");
    if (!$ta_check) {
        echo "Error: " . mysqli_error($ahk_conn);
        exit;
    }

    if (mysqli_num_rows($ta_check) == 1) {
        $hkb_status = mysqli_fetch_array($ta_check);
        if ($hkb_status['status'] == "pending") {
            // Assume payment is successful without checking API response
            $amount = $hkb_status['amount']; // Assuming the amount is stored in the wallet table
            $utrt = uniqid(); // Generate a unique transaction reference
            $resultInfo = "Payment processed successfully"; // Sample message

            // Update user balance
            $sql = "UPDATE users SET balance = balance + ? WHERE phone = ?";
            $stmt = $ahk_conn->prepare($sql);
            $stmt->bind_param("ds", $amount, $customer_mobile);

            if ($stmt->execute()) {
                // Update wallet status
                $sql2 = "UPDATE wallet SET status = 'success', amount=?, BANKTXNID=?, RESPMSG=? WHERE txn_id = ?";
                $stmt2 = $ahk_conn->prepare($sql2);
                $stmt2->bind_param("dsss", $amount, $utrt, $resultInfo, $order_id);

                if ($stmt2->execute()) {
                    echo "<script>
                    Swal.fire({
                        title: 'SUCCESS',
                        text: 'WALLET UPDATED SUCCESSFULLY',
                        icon: 'success',
                        confirmButtonText: 'OK'
                    }).then(function() {
                        window.location.href = 'https://".$_SERVER['SERVER_NAME']."/admin/wallet.php';
                    });
                    </script>";
                } else {
                    echo "<script>
                    Swal.fire({
                        title: 'WALLET UPDATE FAILED',
                        text: 'Update failed: " . $stmt2->error . "',
                        icon: 'error',
                        confirmButtonText: 'OK'
                    }).then(function() {
                        window.location.href = 'https://".$_SERVER['SERVER_NAME']."/admin/wallet.php';
                    });
                    </script>";
                }
                $stmt2->close();
            } else {
                echo "<script>
                Swal.fire({
                    title: 'WALLET UPDATE FAILED',
                    text: 'Update failed: " . $stmt->error . "',
                    icon: 'error',
                    confirmButtonText: 'OK'
                }).then(function() {
                    window.location.href = 'https://".$_SERVER['SERVER_NAME']."/admin/wallet.php';
                });
                </script>";
            }
            $stmt->close();
        } else {
            echo "<script>
            Swal.fire({
                title: 'Don\'t try to Repeat Payment',
                text: 'Wallet Already Updated Successfully!',
                icon: 'warning',
                confirmButtonText: 'OK'
            }).then(function() {
                window.location.href = 'https://".$_SERVER['SERVER_NAME']."/admin/wallet.php';
            });
            </script>";
        }
    }
} else {
    echo "<script>Swal.fire('Error', 'Order ID not set in session', 'error');</script>";
}
?>

</body>
</html>
